/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.util.ClaimGrouper;
import io.icker.factions.util.WorldUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_3218;

public class BlueMapWrapper {
    private HashMap<String, MarkerSet> markerSets = new HashMap();
    private BlueMapAPI api;
    private boolean loadWhenReady = false;

    public BlueMapWrapper() {
        BlueMapAPI.onEnable(api -> {
            this.markerSets.clear();
            this.api = api;
            this.generateMarkers();
        });
        ClaimEvents.ADD.register(claim -> this.generateMarkers());
        ClaimEvents.REMOVE.register((x, z, level, faction) -> this.generateMarkers());
        WorldUtils.ON_READY.register(() -> {
            if (this.loadWhenReady) {
                this.loadWhenReady = false;
                this.generateMarkers();
            }
        });
        FactionEvents.SET_HOME.register(this::setHome);
        FactionEvents.MODIFY.register(faction -> this.generateMarkers());
        FactionEvents.MEMBER_JOIN.register((faction, user) -> this.generateMarkers());
        FactionEvents.MEMBER_LEAVE.register((faction, user) -> this.generateMarkers());
        FactionEvents.POWER_CHANGE.register((faction, oldPower) -> this.generateMarkers());
        FactionEvents.DISBAND.register(faction -> this.generateMarkers());
    }

    private void generateMarkers() {
        if (!WorldUtils.isReady()) {
            this.loadWhenReady = true;
            FactionsMod.LOGGER.info("Server hasn't loaded, postponing dynmap marker loading");
            return;
        }
        for (MarkerSet set : this.markerSets.values()) {
            for (String id : set.getMarkers().keySet()) {
                set.remove(id);
            }
        }
        for (Faction faction : Faction.all()) {
            Home home = faction.getHome();
            if (home != null) {
                this.setHome(faction, home);
            }
            String info = this.getInfo(faction);
            for (Map.Entry<String, Set<Vector2i>> entry : ClaimGrouper.separateClaimsByLevel(faction).entrySet()) {
                String level = entry.getKey();
                for (Map<Vector2i, Vector2i[]> group : ClaimGrouper.convertClaimsToLineSegmentGroups(entry.getValue())) {
                    List<List<Vector2i>> outlines = ClaimGrouper.convertLineSegmentsToOutlines(group);
                    List<Shape> shapes = outlines.stream().map(hole -> new Shape((Collection)hole.stream().map(point -> new Vector2d((float)point.getX(), (float)point.getY())).collect(Collectors.toList()))).collect(Collectors.toList());
                    MarkerSet markerSet = this.markerSets.get(level);
                    if (markerSet == null) {
                        class_3218 world = WorldUtils.getWorld(level);
                        markerSet = new MarkerSet("factions-" + level);
                        for (BlueMapMap map : ((BlueMapWorld)this.api.getWorld((Object)world).get()).getMaps()) {
                            map.getMarkerSets().put("factions-" + level, markerSet);
                        }
                        this.markerSets.put(level, markerSet);
                    }
                    ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().position((double)outlines.get(0).get(0).getX(), 320.0, (double)outlines.get(0).get(0).getY())).shape((Shape)shapes.removeFirst(), -64.0f, 320.0f).holes(shapes.toArray(new Shape[0])).fillColor(new Color(faction.getColor().method_532() | 0x40000000)).lineColor(new Color(faction.getColor().method_532() | 0xFF000000)).label(faction.getName())).detail(info)).build();
                    markerSet.put(UUID.randomUUID().toString(), (Marker)marker);
                }
            }
        }
    }

    private void setHome(Faction faction, Home home) {
        if (home == null) {
            for (Map.Entry<String, MarkerSet> entry : this.markerSets.entrySet()) {
                entry.getValue().remove(faction.getID().toString() + "-home");
            }
            return;
        }
        MarkerSet markerSet = this.markerSets.get(home.level);
        if (markerSet == null) {
            class_3218 world = WorldUtils.getWorld(home.level);
            markerSet = new MarkerSet("factions-" + home.level);
            for (BlueMapMap map : ((BlueMapWorld)this.api.getWorld((Object)world).get()).getMaps()) {
                map.getMarkerSets().put("factions-" + home.level, markerSet);
            }
            this.markerSets.put(home.level, markerSet);
        }
        for (Map.Entry entry : this.markerSets.entrySet()) {
            if (((String)entry.getKey()).equals(home.level)) continue;
            ((MarkerSet)entry.getValue()).remove(faction.getID().toString() + "-home");
        }
        Marker marker = markerSet.get(faction.getID().toString() + "-home");
        if (marker == null) {
            POIMarker pOIMarker = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().position(home.x, home.y, home.z)).detail(this.getInfo(faction)).label(faction.getName() + "'s Home")).build();
            markerSet.put(faction.getID().toString() + "-home", (Marker)pOIMarker);
        } else {
            ((POIMarker)marker).setPosition(home.x, home.y, home.z);
        }
    }

    private String getInfo(Faction faction) {
        return "Name: " + faction.getName() + "<br>Description: " + faction.getDescription() + "<br>Power: " + faction.getPower() + "<br>Number of members: " + faction.getUsers().size();
    }
}

