/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import com.flowpowered.math.vector.Vector2i;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClaimGrouper {
    public static Map<String, Set<Vector2i>> separateClaimsByLevel(Faction faction) {
        HashMap<String, Set<Vector2i>> claims = new HashMap<String, Set<Vector2i>>();
        for (Claim claim : faction.getClaims()) {
            HashSet<Vector2i> level_claim_points = (HashSet<Vector2i>)claims.get(claim.level);
            if (level_claim_points != null) {
                level_claim_points.add(new Vector2i(claim.x, claim.z));
                continue;
            }
            level_claim_points = new HashSet<Vector2i>();
            level_claim_points.add(new Vector2i(claim.x, claim.z));
            claims.put(claim.level, level_claim_points);
        }
        return claims;
    }

    public static List<Map<Vector2i, Vector2i[]>> convertClaimsToLineSegmentGroups(Set<Vector2i> claims) {
        HashSet<Vector2i> remaining_claims = new HashSet<Vector2i>(claims);
        LinkedList<Vector2i> queue = new LinkedList<Vector2i>();
        ArrayList<Map<Vector2i, Vector2i[]>> groups = new ArrayList<Map<Vector2i, Vector2i[]>>();
        while (!remaining_claims.isEmpty()) {
            Iterator iter = remaining_claims.iterator();
            Vector2i item = (Vector2i)iter.next();
            queue.add(item);
            remaining_claims.remove(item);
            HashMap<Vector2i, Vector2i[]> lines = new HashMap<Vector2i, Vector2i[]>();
            while (!queue.isEmpty()) {
                Vector2i claim = (Vector2i)queue.remove();
                for (Vector2i dir : new Vector2i[]{new Vector2i(1, 0), new Vector2i(-1, 0), new Vector2i(0, 1), new Vector2i(0, -1)}) {
                    Vector2i end;
                    Vector2i start;
                    Vector2i new_claim = claim.add(dir);
                    if (remaining_claims.contains(new_claim)) {
                        queue.add(new_claim);
                        remaining_claims.remove(new_claim);
                    }
                    if (claims.contains(new_claim)) continue;
                    if (dir.getX() == 0) {
                        start = claim.mul(16).add(new Vector2i(dir.getY(), dir.getY()).mul(8));
                        end = claim.mul(16).add(new Vector2i(-dir.getY(), dir.getY()).mul(8));
                    } else {
                        start = claim.mul(16).add(new Vector2i(dir.getX(), -dir.getX()).mul(8));
                        end = claim.mul(16).add(new Vector2i(dir.getX(), dir.getX()).mul(8));
                    }
                    start = start.add(new Vector2i(8, 8));
                    end = end.add(new Vector2i(8, 8));
                    if (lines.containsKey(start)) {
                        lines.put(start, new Vector2i[]{((Vector2i[])lines.get(start))[0], end});
                        continue;
                    }
                    lines.put(start, new Vector2i[]{end});
                }
            }
            groups.add(lines);
        }
        return groups;
    }

    private static int getDir(Vector2i end, Vector2i start) {
        if (end.getY() > start.getY()) {
            return 0;
        }
        if (end.getY() < start.getY()) {
            return 2;
        }
        if (end.getX() > start.getX()) {
            return 1;
        }
        return 3;
    }

    private static boolean isCounterClockwiseTurn(int next, int last) {
        if (next == 0 && last == 3) {
            return false;
        }
        if (next == 3 && last == 0) {
            return true;
        }
        return next < last;
    }

    public static List<List<Vector2i>> convertLineSegmentsToOutlines(Map<Vector2i, Vector2i[]> lines) {
        ArrayList<List<Vector2i>> holes = new ArrayList<List<Vector2i>>();
        ArrayList<Vector2i> outline = null;
        while (!lines.isEmpty()) {
            int dir;
            Vector2i new_point;
            Vector2i[] dests;
            ArrayList<Vector2i> line = new ArrayList<Vector2i>();
            int rotations = 0;
            int last_dir = -1;
            Vector2i point = lines.values().iterator().next()[0];
            while (true) {
                dests = lines.get(point);
                new_point = dests[0];
                dir = ClaimGrouper.getDir(new_point, point);
                if (last_dir != -1 && last_dir != dir) break;
                point = new_point;
                last_dir = dir;
            }
            while (lines.containsKey(point)) {
                dests = lines.remove(point);
                if (dests.length > 1) {
                    int dir0 = ClaimGrouper.getDir(dests[0], point);
                    int dir1 = ClaimGrouper.getDir(dests[1], point);
                    int chosen_idx = (dir0 + 2) % 4 == last_dir ? 1 : ((dir1 + 2) % 4 == last_dir ? 0 : (ClaimGrouper.isCounterClockwiseTurn(dir0, last_dir) ? 0 : (ClaimGrouper.isCounterClockwiseTurn(dir1, last_dir) ? 1 : (dir0 == last_dir ? 0 : 1))));
                    new_point = dests[chosen_idx];
                    lines.put(point, new Vector2i[]{dests[(chosen_idx + 1) % 2]});
                } else {
                    new_point = dests[0];
                }
                dir = ClaimGrouper.getDir(new_point, point);
                rotations = dir == 0 && last_dir == 3 ? ++rotations : (dir == 3 && last_dir == 0 ? --rotations : (rotations += dir - last_dir));
                if (last_dir % 2 != dir % 2) {
                    line.add(point);
                }
                point = new_point;
                last_dir = dir;
            }
            if (rotations < 0) {
                outline = line;
                continue;
            }
            holes.add(line);
        }
        holes.add(0, outline);
        return holes;
    }

    public static List<Map<Vector2i, Vector2i[]>> convertClaimsToLineSegmentGroupsWithoutHoles(Set<Vector2i> claims) {
        HashSet<Vector2i> remaining_claims = new HashSet<Vector2i>(claims);
        LinkedList<Vector2i> queue = new LinkedList<Vector2i>();
        ArrayList<Map<Vector2i, Vector2i[]>> groups = new ArrayList<Map<Vector2i, Vector2i[]>>();
        while (!remaining_claims.isEmpty()) {
            Iterator iter = remaining_claims.iterator();
            Vector2i item = (Vector2i)iter.next();
            queue.add(item);
            remaining_claims.remove(item);
            HashMap<Vector2i, Vector2i[]> lines = new HashMap<Vector2i, Vector2i[]>();
            while (!queue.isEmpty()) {
                Vector2i claim = (Vector2i)queue.remove();
                for (Vector2i dir : new Vector2i[]{new Vector2i(1, 0), new Vector2i(-1, 0), new Vector2i(0, 1), new Vector2i(0, -1)}) {
                    Vector2i end;
                    Vector2i start;
                    Vector2i new_claim = claim.add(dir);
                    if (remaining_claims.contains(new_claim)) {
                        queue.add(new_claim);
                        remaining_claims.remove(new_claim);
                        continue;
                    }
                    if (dir.getX() == 0) {
                        start = claim.mul(16).add(new Vector2i(dir.getY(), dir.getY()).mul(8));
                        end = claim.mul(16).add(new Vector2i(-dir.getY(), dir.getY()).mul(8));
                    } else {
                        start = claim.mul(16).add(new Vector2i(dir.getX(), -dir.getX()).mul(8));
                        end = claim.mul(16).add(new Vector2i(dir.getX(), dir.getX()).mul(8));
                    }
                    start = start.add(new Vector2i(8, 8));
                    end = end.add(new Vector2i(8, 8));
                    boolean has_opposite_line = false;
                    if (lines.containsKey(end)) {
                        for (Vector2i possible_start : (Vector2i[])lines.get(end)) {
                            if (!possible_start.equals((Object)start)) continue;
                            has_opposite_line = true;
                        }
                    }
                    if (!has_opposite_line && claims.contains(new_claim) && !queue.contains(new_claim) && !remaining_claims.contains(new_claim)) continue;
                    if (lines.containsKey(start)) {
                        lines.put(start, new Vector2i[]{((Vector2i[])lines.get(start))[0], end});
                        continue;
                    }
                    lines.put(start, new Vector2i[]{end});
                }
            }
            groups.add(lines);
        }
        return groups;
    }
}

