/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11755;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;

public interface Command {
    public static final boolean permissions = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");

    public LiteralCommandNode<class_2168> getNode();

    public static User getUser(class_3222 player) {
        User user = User.get(player.method_5667());
        if (user.getSpoof() == null) {
            return user;
        }
        return user.getSpoof();
    }

    public static interface Suggests {
        public String[] run(User var1);

        public static SuggestionProvider<class_2168> allFactions() {
            return Suggests.allFactions(true);
        }

        public static SuggestionProvider<class_2168> allFactions(boolean includeYou) {
            return Suggests.suggest(user -> (String[])Faction.all().stream().filter(f -> includeYou || !user.isInFaction() || !user.getFaction().getID().equals(f.getID())).map(f -> f.getName()).toArray(String[]::new));
        }

        public static SuggestionProvider<class_2168> allPlayers() {
            return (context, builder) -> {
                class_11755 resolver = ((class_2168)context.getSource()).method_9211().method_73550().comp_4624();
                for (User user : User.all()) {
                    Optional player = resolver.method_73290(user.getID());
                    if (player.isPresent()) {
                        builder.suggest(((GameProfile)player.get()).name());
                        continue;
                    }
                    builder.suggest(user.getID().toString());
                }
                return builder.buildFuture();
            };
        }

        public static SuggestionProvider<class_2168> allPlayersInYourFactionButYou() {
            return (context, builder) -> {
                class_11755 resolver = ((class_2168)context.getSource()).method_9211().method_73550().comp_4624();
                class_3222 entity = ((class_2168)context.getSource()).method_9207();
                User currentUser = User.get(entity.method_5667());
                if (!currentUser.isInFaction()) {
                    return builder.buildFuture();
                }
                for (User user : User.all()) {
                    if (user.getID().equals(currentUser.getID()) || !user.isInFaction() || !user.getFaction().equals(currentUser.getFaction())) continue;
                    Optional player = resolver.method_73290(user.getID());
                    if (player.isPresent()) {
                        builder.suggest(((GameProfile)player.get()).name());
                        continue;
                    }
                    builder.suggest(user.getID().toString());
                }
                return builder.buildFuture();
            };
        }

        public static SuggestionProvider<class_2168> openFactions() {
            return Suggests.suggest(user -> (String[])Faction.all().stream().filter(f -> f.isOpen()).map(f -> f.getName()).toArray(String[]::new));
        }

        public static SuggestionProvider<class_2168> openInvitedFactions() {
            return Suggests.suggest(user -> (String[])Faction.all().stream().filter(f -> f.isOpen() || f.isInvited(user.getID())).map(f -> f.getName()).toArray(String[]::new));
        }

        public static <T extends Enum<T>> SuggestionProvider<class_2168> enumSuggestion(Class<T> clazz) {
            return Suggests.suggest(user -> (String[])Arrays.stream((Enum[])clazz.getEnumConstants()).map(Enum::toString).toArray(String[]::new));
        }

        public static SuggestionProvider<class_2168> suggest(Suggests sug) {
            return (context, builder) -> {
                class_3222 entity = ((class_2168)context.getSource()).method_9207();
                User user = User.get(entity.method_5667());
                for (String suggestion : sug.run(user)) {
                    builder.suggest(suggestion);
                }
                return builder.buildFuture();
            };
        }
    }

    public static interface Requires {
        public boolean run(User var1);

        @SafeVarargs
        public static Predicate<class_2168> multiple(Predicate<class_2168> ... args) {
            return source -> {
                for (Predicate predicate : args) {
                    if (predicate.test(source)) continue;
                    return false;
                }
                return true;
            };
        }

        public static Predicate<class_2168> isFactionless() {
            return Requires.require(user -> !user.isInFaction());
        }

        public static Predicate<class_2168> isMember() {
            return Requires.require(user -> user.isInFaction());
        }

        public static Predicate<class_2168> isCommander() {
            return Requires.require(user -> user.rank == User.Rank.COMMANDER || user.rank == User.Rank.LEADER || user.rank == User.Rank.OWNER);
        }

        public static Predicate<class_2168> isLeader() {
            return Requires.require(user -> user.rank == User.Rank.LEADER || user.rank == User.Rank.OWNER);
        }

        public static Predicate<class_2168> isOwner() {
            return Requires.require(user -> user.rank == User.Rank.OWNER);
        }

        public static Predicate<class_2168> isAdmin() {
            return source -> source.method_9259(FactionsMod.CONFIG.REQUIRED_BYPASS_LEVEL);
        }

        public static Predicate<class_2168> hasPerms(String permission, int defaultValue) {
            return source -> {
                if (permissions) {
                    return Permissions.check((class_2172)source, (String)permission, (int)defaultValue);
                }
                return source.method_9259(defaultValue);
            };
        }

        public static Predicate<class_2168> require(Requires req) {
            return source -> {
                class_3222 entity = source.method_44023();
                if (entity == null) {
                    return false;
                }
                User user = Command.getUser(entity);
                return req.run(user);
            };
        }
    }
}

