/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.client.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentConfigBuilderWidget;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.FloatSlider;
import fr.frinn.custommachinery.client.screen.widget.IntegerEditBox;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinerypnc.common.Registration;
import fr.frinn.custommachinerypnc.common.component.PressureMachineComponent;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class PressureComponentBuilder
implements IMachineComponentBuilder<PressureMachineComponent, PressureMachineComponent.Template> {
    public MachineComponentType<PressureMachineComponent> type() {
        return Registration.PRESSURE_COMPONENT.get();
    }

    public PopupScreen makePopup(MachineEditScreen parent, @Nullable PressureMachineComponent.Template template, Consumer<PressureMachineComponent.Template> onFinish) {
        return new PressureComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height, PressureMachineComponent.Template template) {
        graphics.renderFakeItem(ModItems.PRESSURE_GAUGE.toStack(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
    }

    public static class PressureComponentBuilderPopup
    extends ComponentBuilderPopup<PressureMachineComponent.Template> {
        private IntegerEditBox volume;
        private FloatSlider danger;
        private FloatSlider critical;
        private ToggleSideConfig.Template config;

        public PressureComponentBuilderPopup(BaseScreen parent, @Nullable PressureMachineComponent.Template template, Consumer<PressureMachineComponent.Template> onFinish) {
            super(parent, (IMachineComponentTemplate)template, onFinish, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.title"));
        }

        public PressureMachineComponent.Template makeTemplate() {
            return new PressureMachineComponent.Template(this.volume.getIntValue(), this.danger.floatValue(), this.critical.floatValue(), this.config);
        }

        public Component canCreate() {
            if (this.critical.floatValue() < this.danger.floatValue()) {
                return Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.critical_inferior");
            }
            return super.canCreate();
        }

        protected void init() {
            super.init();
            this.volume = (IntegerEditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.volume"), (AbstractWidget)new IntegerEditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.volume")));
            this.volume.bounds(0, Integer.MAX_VALUE);
            this.baseTemplate().ifPresentOrElse(template -> this.volume.setValue("" + template.volume()), () -> this.volume.setValue("5000"));
            this.volume.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.volume.tooltip")));
            this.danger = (FloatSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.danger"), (AbstractWidget)new FloatSlider.Builder().bounds(-1.0f, 25.0f).displayOnlyValue().decimalsToShow(1).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.danger")));
            this.baseTemplate().ifPresentOrElse(template -> this.danger.setValue(template.danger()), () -> this.danger.setValue(3.0f));
            this.danger.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.danger.tooltip")));
            this.critical = (FloatSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.critical"), (AbstractWidget)new FloatSlider.Builder().bounds(-1.0f, 25.0f).displayOnlyValue().decimalsToShow(1).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.critical")));
            this.baseTemplate().ifPresentOrElse(template -> this.critical.setValue(template.critical()), () -> this.critical.setValue(5.0f));
            this.critical.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.critical.tooltip")));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.config = template.config();
            }, () -> {
                this.config = ToggleSideConfig.Template.DEFAULT_ALL_ENABLED;
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.config.component"), (AbstractWidget)ComponentConfigBuilderWidget.make((int)0, (int)0, (int)180, (int)20, (Component)Component.translatable((String)"custommachinery.gui.config.component"), (BaseScreen)this.parent, () -> this.config, template -> {
                this.config = template;
            }));
        }
    }
}

