/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.client.jei.heat;

import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.impl.util.IntRange;
import fr.frinn.custommachinerypnc.client.jei.CMPncJeiPlugin;
import fr.frinn.custommachinerypnc.client.jei.heat.Heat;
import fr.frinn.custommachinerypnc.client.jei.heat.HeatJeiIngredientRenderer;
import fr.frinn.custommachinerypnc.common.Registration;
import fr.frinn.custommachinerypnc.common.component.HeatMachineComponent;
import fr.frinn.custommachinerypnc.common.guielement.HeatGuiElement;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public record HeatJeiIngredientWrapper(RequirementIOMode mode, Heat heat, boolean perTick, @Nullable IntRange range) implements IJEIIngredientWrapper<Heat>
{
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        HeatGuiElement heatElement;
        block5: {
            block4: {
                if (!(element instanceof HeatGuiElement)) break block4;
                heatElement = (HeatGuiElement)element;
                if (element.getType() == Registration.HEAT_ELEMENT.get()) break block5;
            }
            return false;
        }
        HeatMachineComponent.Template template = helper.getComponentForElement((IComponentGuiElement)heatElement).orElse(null);
        if (template != null) {
            ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset + 1, element.getY() - yOffset + 1).setCustomRenderer(CMPncJeiPlugin.HEAT_INGREDIENT, (IIngredientRenderer)new HeatJeiIngredientRenderer(heatElement, this.heat.amount())).addIngredient(CMPncJeiPlugin.HEAT_INGREDIENT, (Object)this.heat)).addRichTooltipCallback((view, tooltip) -> {
                if (this.mode == RequirementIOMode.INPUT) {
                    if (this.range != null) {
                        tooltip.add((FormattedText)Component.translatable((String)"custommachinerypnc.jei.ingredient.temperature.range", (Object[])new Object[]{this.range.toFormattedString()}));
                    } else if (this.perTick) {
                        tooltip.add((FormattedText)Component.translatable((String)"custommachinerypnc.jei.ingredient.heat.input.per-tick", (Object[])new Object[]{this.heat.amount()}));
                    } else {
                        tooltip.add((FormattedText)Component.translatable((String)"custommachinerypnc.jei.ingredient.heat.input", (Object[])new Object[]{this.heat.amount()}));
                    }
                } else if (this.perTick) {
                    tooltip.add((FormattedText)Component.translatable((String)"custommachinerypnc.jei.ingredient.heat.output.per-tick", (Object[])new Object[]{this.heat.amount()}));
                } else {
                    tooltip.add((FormattedText)Component.translatable((String)"custommachinerypnc.jei.ingredient.heat.output", (Object[])new Object[]{this.heat.amount()}));
                }
            });
        }
        return true;
    }
}

