/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.common.integration.kubejs;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.impl.util.IntRange;
import fr.frinn.custommachinerypnc.common.requirement.HeatPerTickRequirement;
import fr.frinn.custommachinerypnc.common.requirement.HeatRequirement;
import fr.frinn.custommachinerypnc.common.requirement.TemperatureRequirement;

public interface HeatRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder requirePNCHeat(int amount) {
        if (amount <= 0) {
            return this.error("Invalid heat amount specified: {}", new Object[]{amount});
        }
        return this.addRequirement(new HeatRequirement(RequirementIOMode.INPUT, amount));
    }

    default public RecipeJSBuilder producePNCHeat(int amount) {
        if (amount <= 0) {
            return this.error("Invalid heat amount specified: {}", new Object[]{amount});
        }
        return this.addRequirement(new HeatRequirement(RequirementIOMode.OUTPUT, amount));
    }

    default public RecipeJSBuilder requirePNCHeatPerTick(int amount) {
        if (amount <= 0) {
            return this.error("Invalid heat amount specified: {}", new Object[]{amount});
        }
        return this.addRequirement(new HeatPerTickRequirement(RequirementIOMode.INPUT, amount));
    }

    default public RecipeJSBuilder producePNCHeatPerTick(int amount) {
        if (amount <= 0) {
            return this.error("Invalid heat amount specified: {}", new Object[]{amount});
        }
        return this.addRequirement(new HeatPerTickRequirement(RequirementIOMode.OUTPUT, amount));
    }

    default public RecipeJSBuilder requirePNCTemperature(IntRange range) {
        if (range == null) {
            return this.error("Invalid range in PNC temperature requirement", new Object[0]);
        }
        return this.addRequirement(new TemperatureRequirement(range));
    }
}

