/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.common.mixin;

import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.integration.kubejs.function.MachineJS;
import fr.frinn.custommachinerypnc.common.Registration;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MachineJS.class}, remap=false)
public abstract class MachineJSMixin {
    @Final
    @Shadow(remap=false)
    private CustomMachineTile internal;

    public float getPressure() {
        return this.internal.getComponentManager().getComponent(Registration.PRESSURE_COMPONENT.get()).map(component -> Float.valueOf(component.getHandler().getPressure())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void setPressure(float pressure) {
        this.internal.getComponentManager().getComponent(Registration.PRESSURE_COMPONENT.get()).ifPresent(component -> component.getHandler().setPressure(pressure));
    }

    public int getAir() {
        return this.internal.getComponentManager().getComponent(Registration.PRESSURE_COMPONENT.get()).map(component -> component.getHandler().getAir()).orElse(0);
    }

    public void addAir(int air) {
        this.internal.getComponentManager().getComponent(Registration.PRESSURE_COMPONENT.get()).ifPresent(component -> component.getHandler().addAir(air));
    }

    public void addPNCHeat(double amount) {
        this.internal.getComponentManager().getComponent(Registration.HEAT_COMPONENT.get()).ifPresent(component -> component.getHeatExchanger().addHeat(amount));
    }

    public double getPNCTemperature() {
        return this.internal.getComponentManager().getComponent(Registration.HEAT_COMPONENT.get()).map(component -> component.getHeatExchanger().getTemperature()).orElse(0.0);
    }

    public double getAmbientPNCTemperature() {
        return this.internal.getComponentManager().getComponent(Registration.HEAT_COMPONENT.get()).map(component -> component.getHeatExchanger().getAmbientTemperature()).orElse(0.0);
    }

    public void setPNCTemperature(double temperature) {
        this.internal.getComponentManager().getComponent(Registration.HEAT_COMPONENT.get()).ifPresent(component -> component.getHeatExchanger().setTemperature(temperature));
    }
}

