/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.util.IntRange;
import fr.frinn.custommachinery.impl.util.Restriction;
import fr.frinn.custommachinerypnc.client.jei.heat.Heat;
import fr.frinn.custommachinerypnc.client.jei.heat.HeatJeiIngredientWrapper;
import fr.frinn.custommachinerypnc.common.Registration;
import fr.frinn.custommachinerypnc.common.component.HeatMachineComponent;
import java.util.List;
import net.minecraft.network.chat.Component;

public record TemperatureRequirement(IntRange range) implements IRequirement<HeatMachineComponent>,
IJEIIngredientRequirement<Heat>
{
    public static final NamedCodec<TemperatureRequirement> CODEC = NamedCodec.record(temperatureRequirementInstance -> temperatureRequirementInstance.group((App)IntRange.CODEC.fieldOf("temperature").forGetter(TemperatureRequirement::range)).apply((Applicative)temperatureRequirementInstance, TemperatureRequirement::new), (String)"PNC Temperature requirement");

    public RequirementType<TemperatureRequirement> getType() {
        return Registration.TEMPERATURE_REQUIREMENT.get();
    }

    public MachineComponentType<HeatMachineComponent> getComponentType() {
        return Registration.HEAT_COMPONENT.get();
    }

    public RequirementIOMode getMode() {
        return RequirementIOMode.INPUT;
    }

    public boolean test(HeatMachineComponent component, ICraftingContext context) {
        return this.range.contains((Comparable)Integer.valueOf(component.getHeatExchanger().getTemperatureAsInt() - 273));
    }

    public void gatherRequirements(IRequirementList<HeatMachineComponent> list) {
        list.inventoryCondition((component, context) -> {
            if (this.range.contains((Comparable)Integer.valueOf(component.getHeatExchanger().getTemperatureAsInt() - 273))) {
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerypnc.requirements.temperature.error", (Object[])new Object[]{component.getHeatExchanger().getTemperatureAsInt() - 273}));
        });
    }

    public List<IJEIIngredientWrapper<Heat>> getJEIIngredientWrappers(IMachineRecipe recipe, RecipeRequirement<?, ?> requirement) {
        int amount = this.range.getRestrictions().stream().mapToInt(Restriction::lowerBound).min().orElse(0);
        return List.of(new HeatJeiIngredientWrapper(RequirementIOMode.INPUT, new Heat(amount), false, this.range));
    }
}

