/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fair.command;

import cn.handyplus.fair.constants.TabListEnum;
import cn.handyplus.fair.lib.annotation.HandyCommand;
import cn.handyplus.fair.lib.command.HandyCommandWrapper;
import cn.handyplus.fair.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="fair")
public class FairDanTiaoCommand
implements TabExecutor {
    private static final String PERMISSION = "fair.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        boolean rst = HandyCommandWrapper.onCommand(sender, cmd, label, args, BaseUtil.getLangMsg("noPermission"));
        if (!rst) {
            this.sendHelp(sender);
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<Object> commands = !sender.hasPermission(PERMISSION) ? new ArrayList() : TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return;
        }
        ArrayList<String> helps = new ArrayList<String>();
        helps.add("&a/fair reload  - \u91cd\u8f7d\u63d2\u4ef6");
        for (String help : helps) {
            sender.sendMessage(BaseUtil.replaceChatColor(help));
        }
    }
}

