/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fair.lib.core;

import cn.handyplus.fair.lib.core.PatternUtil;
import cn.handyplus.fair.lib.core.StrUtil;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.regex.Matcher;

public class NumberUtil {
    private NumberUtil() {
    }

    public static Integer isNumericToInt(String str) {
        return NumberUtil.isNumericToInt(str, null);
    }

    public static Integer isNumericToInt(String str, Integer def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::intValue).orElse(def);
    }

    public static Double isNumericToDouble(String str) {
        return NumberUtil.isNumericToDouble(str, null);
    }

    public static Double isNumericToDouble(String str, Double def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::doubleValue).orElse(def);
    }

    public static Long isNumericToLong(String str) {
        return NumberUtil.isNumericToLong(str, null);
    }

    public static Long isNumericToLong(String str, Long def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::longValue).orElse(def);
    }

    public static Optional<BigDecimal> isNumericToBigDecimal(String str) {
        return NumberUtil.isNumericToBigDecimal(str, null);
    }

    public static Optional<BigDecimal> isNumericToBigDecimal(String str, BigDecimal def) {
        if (StrUtil.isEmpty(str)) {
            return Optional.ofNullable(def);
        }
        try {
            Matcher isNum = PatternUtil.BIG_DECIMAL_NUMERIC.matcher(str);
            if (isNum.matches()) {
                return Optional.of(new BigDecimal(str));
            }
        }
        catch (NumberFormatException e) {
            return Optional.ofNullable(def);
        }
        return Optional.ofNullable(def);
    }
}

