/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fair.lib.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternUtil {
    public static final Pattern VERSION_PATTERN = Pattern.compile("\\(MC: (?<version>\\d+\\.\\d+(\\.\\d+)?)\\)");
    public static final Pattern BIG_DECIMAL_NUMERIC = Pattern.compile("-?\\d+(\\.\\d+)?([eE][+-]?\\d+)?");
    public static final Pattern RPG_PATTERN = Pattern.compile("&#([0-9a-fA-F]){6}|&#([0-9a-fA-F]){3}|\u00a7#([0-9a-fA-F]){6}|\u00a7#([0-9a-fA-F]){3}");
    public static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    public static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    public static final Pattern TEMPLATE_EXPRESSION_REGEX = Pattern.compile("\\$\\{(.*?)}");
    public static final Pattern AT_WORD_PATTERN = Pattern.compile("@(\\w+)");

    private PatternUtil() {
    }

    public static boolean contains(String input, String str) {
        Pattern pattern = Pattern.compile("(?i).*" + Pattern.quote(str) + ".*");
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static String replaceFirst(String input, String str) {
        return input.replaceFirst("(?i)" + Pattern.quote(str), "").trim();
    }

    public static String replaceAll(String input, String str) {
        return input.replaceAll("(?i)" + Pattern.quote(str), "").trim();
    }

    public static List<String> extractAtTags(String input) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = AT_WORD_PATTERN.matcher(input);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }
}

