/*
 * Decompiled with CFR 0.152.
 */
package com.lne_archers.item;

import com.lne_archers.LNE_ArchersMod;
import com.lne_archers.config.TweaksConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import more_rpg_loot.item.Group;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.SpellWeaponItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_power.api.SpellSchools;

public class WeaponsRegister {
    public static final ArrayList<RangedEntry> rangedEntries = new ArrayList();
    public static final ArrayList<Weapon.Entry> meleeEntries = new ArrayList();
    private static final float pullTime_shortBow = -0.19999999f;
    private static final float pullTime_longBow = 0.5f;
    private static final float pullTime_rapidCrossbow = 0.0f;
    private static final float pullTime_heavyCrossbow = 0.75f;
    private static final float velocity_shortBow = 0.0f;
    private static final float velocity_longBow = 0.75f;
    private static final float velocity_rapidCrossbow = 0.0f;
    private static final float velocity_heavyCrossbow = 0.5f;
    public static float short_bow_damage = 10.0f;
    public static float long_bow_damage = 13.5f;
    public static float rapid_crossbow_damage = 10.5f;
    public static float heavy_crossbow_damage = 17.0f;
    private static final int durabilityBows = Tiers.NETHERITE.getUses();
    private static final float archers_spearAttackSpeed = -2.6f;
    private static final float spearAttackDamage = 8.0f;
    private static final float weaponSpellPower = 4.0f;
    public static ResourceLocation dragonclaw = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"dragonclaw");
    public static ResourceLocation avalanche = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"avalanche");
    public static ResourceLocation waterbomb = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"waterbomb");
    public static ResourceLocation wither_pulse = ResourceLocation.fromNamespaceAndPath((String)"loot_n_explore", (String)"wither_pulse");
    public static ResourceLocation dragon_breath = ResourceLocation.fromNamespaceAndPath((String)"lne_archers", (String)"dragon_breath");
    public static ResourceLocation reef_arrows = ResourceLocation.fromNamespaceAndPath((String)"lne_archers", (String)"reef_arrows");
    public static ResourceLocation glacial_splitter = ResourceLocation.fromNamespaceAndPath((String)"lne_archers", (String)"glacial_splitter");
    public static ResourceLocation cursed_wither_bolt = ResourceLocation.fromNamespaceAndPath((String)"lne_archers", (String)"cursed_wither_bolt");

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static RangedEntry bow(String name, int durability, Supplier<Ingredient> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(ResourceLocation.fromNamespaceAndPath((String)"lne_archers", (String)name), CustomBow::new, defaults, repairIngredientSupplier, durability);
        rangedEntries.add(entry);
        return entry;
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<Ingredient> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(ResourceLocation.fromNamespaceAndPath((String)"lne_archers", (String)name), CustomCrossbow::new, defaults, repairIngredientSupplier, durability);
        rangedEntries.add(entry);
        return entry;
    }

    private static Weapon.Entry addMelee(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType type) {
        Weapon.Entry entry = new Weapon.Entry("lne_archers", name, material, factory, defaults, type);
        meleeEntries.add(entry);
        return entry;
    }

    private static Weapon.Entry spear(String name, Weapon.CustomMaterial material, float damage) {
        return WeaponsRegister.addMelee(name, material, SpellWeaponItem::new, new WeaponConfig(damage, -2.6f), Equipment.WeaponType.SPEAR);
    }

    public static void register(Map<String, RangedConfig> rangedConfig, Map<String, WeaponConfig> meleeConfig) {
        if (!((TweaksConfig)LNE_ArchersMod.tweaksConfig.value).disable_special_lne_weapons) {
            Supplier<Ingredient> dragonRepair = WeaponsRegister.ingredient("minecraft:amethyst_shard", FabricLoader.getInstance().isModLoaded("loot_n_explore"), Items.NETHERITE_INGOT);
            Supplier<Ingredient> elderGuardianRepair = WeaponsRegister.ingredient("minecraft:prismarine_shard", FabricLoader.getInstance().isModLoaded("loot_n_explore"), Items.NETHERITE_INGOT);
            Supplier<Ingredient> frostMonarchRepair = WeaponsRegister.ingredient("minecraft:ice", FabricLoader.getInstance().isModLoaded("loot_n_explore"), Items.NETHERITE_INGOT);
            Supplier<Ingredient> witherRepair = WeaponsRegister.ingredient("minecraft:bone", FabricLoader.getInstance().isModLoaded("loot_n_explore"), Items.NETHERITE_INGOT);
            WeaponsRegister.spear("ender_dragon_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, dragonRepair), 8.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)4.0f)).spell(dragonclaw);
            WeaponsRegister.spear("elder_guardian_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, elderGuardianRepair), 8.0f).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)4.0f)).spell(waterbomb);
            WeaponsRegister.spear("wither_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, witherRepair), 8.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.SOUL.id, (float)4.0f)).spell(wither_pulse);
            WeaponsRegister.spear("glacial_spear", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, frostMonarchRepair), 8.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)4.0f)).spell(avalanche);
            WeaponsRegister.bow("ender_dragon_bow", durabilityBows, dragonRepair, new RangedConfig(short_bow_damage, -0.19999999f, 0.0f).withAttribute(SpellSchools.ARCANE.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.SHORT_BOW).spell(dragon_breath);
            WeaponsRegister.bow("elder_guardian_bow", durabilityBows, elderGuardianRepair, new RangedConfig(short_bow_damage, -0.19999999f, 0.0f).withAttribute(MoreSpellSchools.WATER.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.SHORT_BOW).spell(reef_arrows);
            WeaponsRegister.bow("wither_bow", durabilityBows, witherRepair, new RangedConfig(short_bow_damage, -0.19999999f, 0.0f).withAttribute(SpellSchools.SOUL.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.SHORT_BOW).spell(cursed_wither_bolt);
            WeaponsRegister.bow("glacial_bow", durabilityBows, frostMonarchRepair, new RangedConfig(short_bow_damage, -0.19999999f, 0.0f).withAttribute(SpellSchools.FROST.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.SHORT_BOW).spell(glacial_splitter);
            WeaponsRegister.bow("ender_dragon_long_bow", durabilityBows, dragonRepair, new RangedConfig(long_bow_damage, 0.5f, 0.75f).withAttribute(SpellSchools.ARCANE.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.LONG_BOW).spell(dragon_breath);
            WeaponsRegister.bow("elder_guardian_long_bow", durabilityBows, elderGuardianRepair, new RangedConfig(long_bow_damage, 0.5f, 0.75f).withAttribute(MoreSpellSchools.WATER.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.LONG_BOW).spell(reef_arrows);
            WeaponsRegister.bow("wither_long_bow", durabilityBows, witherRepair, new RangedConfig(long_bow_damage, 0.5f, 0.75f).withAttribute(SpellSchools.SOUL.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.LONG_BOW).spell(cursed_wither_bolt);
            WeaponsRegister.bow("glacial_long_bow", durabilityBows, frostMonarchRepair, new RangedConfig(long_bow_damage, 0.5f, 0.75f).withAttribute(SpellSchools.FROST.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.LONG_BOW).spell(glacial_splitter);
            WeaponsRegister.crossbow("ender_dragon_rapid_crossbow", durabilityBows, dragonRepair, new RangedConfig(rapid_crossbow_damage, 0.0f, 0.0f).withAttribute(SpellSchools.ARCANE.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).spell(dragon_breath);
            WeaponsRegister.crossbow("elder_guardian_rapid_crossbow", durabilityBows, elderGuardianRepair, new RangedConfig(rapid_crossbow_damage, 0.0f, 0.0f).withAttribute(MoreSpellSchools.WATER.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).spell(reef_arrows);
            WeaponsRegister.crossbow("wither_rapid_crossbow", durabilityBows, witherRepair, new RangedConfig(rapid_crossbow_damage, 0.0f, 0.0f).withAttribute(SpellSchools.SOUL.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).spell(cursed_wither_bolt);
            WeaponsRegister.crossbow("glacial_rapid_crossbow", durabilityBows, frostMonarchRepair, new RangedConfig(rapid_crossbow_damage, 0.0f, 0.0f).withAttribute(SpellSchools.FROST.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.RAPID_CROSSBOW).spell(glacial_splitter);
            WeaponsRegister.crossbow("ender_dragon_heavy_crossbow", durabilityBows, dragonRepair, new RangedConfig(heavy_crossbow_damage, 0.75f, 0.5f).withAttribute(SpellSchools.ARCANE.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.HEAVY_CROSSBOW).spell(dragon_breath);
            WeaponsRegister.crossbow("elder_guardian_heavy_crossbow", durabilityBows, elderGuardianRepair, new RangedConfig(heavy_crossbow_damage, 0.75f, 0.5f).withAttribute(MoreSpellSchools.WATER.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.HEAVY_CROSSBOW).spell(reef_arrows);
            WeaponsRegister.crossbow("wither_heavy_crossbow", durabilityBows, witherRepair, new RangedConfig(heavy_crossbow_damage, 0.75f, 0.5f).withAttribute(SpellSchools.SOUL.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.HEAVY_CROSSBOW).spell(cursed_wither_bolt);
            WeaponsRegister.crossbow("glacial_heavy_crossbow", durabilityBows, frostMonarchRepair, new RangedConfig(heavy_crossbow_damage, 0.75f, 0.5f).withAttribute(SpellSchools.FROST.id, AttributeModifier.Operation.ADD_VALUE, 4.0)).weaponType(Equipment.WeaponType.HEAVY_CROSSBOW).spell(glacial_splitter);
        }
        Weapon.register(meleeConfig, meleeEntries, (ResourceKey)Group.RPG_LOOT_KEY);
        for (RangedEntry entry : rangedEntries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            Item.Properties settings = new Item.Properties();
            int tier = entry.lootProperties.tier();
            settings.rarity(Rarity.RARE);
            settings.fireResistant();
            if (entry.spells != null) {
                if (entry.spells.isEmpty()) {
                    settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForRangedWeapon());
                } else {
                    settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForRangedWeapon(entry.spells));
                }
            }
            Item item = entry.create(settings, config);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id, (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)Group.RPG_LOOT_KEY).register(content -> {
            for (RangedEntry entry : rangedEntries) {
                content.accept((ItemLike)entry.item);
            }
        });
    }

    public static final class RangedEntry {
        private final ResourceLocation id;
        private final RangedFactory factory;
        private final RangedConfig defaults;
        private final Supplier<Ingredient> repairIngredientSupplier;
        private final int durability;
        public List<ResourceLocation> spells = null;
        public Item item;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;
        public Equipment.WeaponType weaponType = Equipment.WeaponType.SHORT_BOW;

        public RangedEntry(ResourceLocation id, RangedFactory factory, RangedConfig defaults, Supplier<Ingredient> repairIngredientSupplier, int durability) {
            this.id = id;
            this.factory = factory;
            this.defaults = defaults;
            this.repairIngredientSupplier = repairIngredientSupplier;
            this.durability = durability;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Item create(Item.Properties settings, RangedConfig config) {
            this.item = this.factory.create(settings.durability(this.durability), config, this.repairIngredientSupplier);
            return this.item;
        }

        public Item item() {
            return this.item;
        }

        public RangedEntry weaponType(Equipment.WeaponType weaponType) {
            this.weaponType = weaponType;
            return this;
        }

        public RangedEntry loot(Equipment.LootProperties lootProperties) {
            this.lootProperties = lootProperties;
            return this;
        }

        public RangedEntry castSpell() {
            this.spells = List.of();
            return this;
        }

        public RangedEntry spell(ResourceLocation spellId) {
            this.spells = List.of(spellId);
            return this;
        }
    }

    public static interface RangedFactory {
        public Item create(Item.Properties var1, RangedConfig var2, Supplier<Ingredient> var3);
    }
}

