/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.client.gui.easel.CanvasWidget;
import me.dantaeusb.zetter.client.gui.easel.HelpWidget;
import me.dantaeusb.zetter.client.gui.easel.HistoryWidget;
import me.dantaeusb.zetter.client.gui.easel.PaletteWidget;
import me.dantaeusb.zetter.client.gui.easel.TabsWidget;
import me.dantaeusb.zetter.client.gui.easel.ToolsWidget;
import me.dantaeusb.zetter.client.gui.easel.ZoomWidget;
import me.dantaeusb.zetter.client.gui.easel.tabs.AbstractTab;
import me.dantaeusb.zetter.client.gui.easel.tabs.BrushParametersTab;
import me.dantaeusb.zetter.client.gui.easel.tabs.BucketParametersTab;
import me.dantaeusb.zetter.client.gui.easel.tabs.ColorTab;
import me.dantaeusb.zetter.client.gui.easel.tabs.InventoryTab;
import me.dantaeusb.zetter.client.gui.easel.tabs.PencilParametersTab;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.SizeParameterHolder;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.painting.tools.ActionListener;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class EaselScreen
extends AbstractContainerScreen<EaselMenu>
implements ContainerListener,
ActionListener {
    public static final ResourceLocation PAINTING_RESOURCE = new ResourceLocation("zetter", "textures/gui/easel.png");
    private final List<AbstractPaintingWidget> paintingWidgets = Lists.newArrayList();
    private HashMap<TabsWidget.Tab, AbstractTab> tabs;
    private ToolsWidget toolsWidget;
    private HistoryWidget historyWidget;
    private ZoomWidget zoomWidget;
    private TabsWidget tabsWidget;
    private CanvasWidget canvasWidget;
    private PaletteWidget paletteWidget;
    private HelpWidget helpWidget;
    private final Player player;
    private double[] dragStart;
    private double[] dragCurrent;
    private int[] dragStartCanvasOffset;
    @Nullable
    private Tools quickToolCache;

    public EaselScreen(EaselMenu paintingContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)paintingContainer, playerInventory, title);
        this.player = playerInventory.f_35978_;
        this.f_97726_ = 206;
        this.f_97727_ = 238;
    }

    protected void m_7856_() {
        super.m_7856_();
        int CANVAS_POSITION_X = 39;
        int CANVAS_POSITION_Y = 9;
        int TOOLS_POSITION_X = 4;
        int TOOLS_POSITION_Y = 4;
        int HISTORY_POSITION_X = 4;
        int HISTORY_POSITION_Y = 112;
        int ZOOM_POSITION_X = 4;
        int ZOOM_POSITION_Y = 142;
        int TABS_POSITION_X = 4;
        int TABS_POSITION_Y = 158;
        int PALETTE_POSITION_X = 175;
        int PALETTE_POSITION_Y = 38;
        int HELP_POSITION_X = 197;
        boolean HELP_POSITION_Y = false;
        this.paintingWidgets.clear();
        this.canvasWidget = new CanvasWidget(this, this.getGuiLeft() + 39, this.getGuiTop() + 9);
        this.paletteWidget = new PaletteWidget(this, this.getGuiLeft() + 175, this.getGuiTop() + 38);
        this.toolsWidget = new ToolsWidget(this, this.getGuiLeft() + 4, this.getGuiTop() + 4);
        this.historyWidget = new HistoryWidget(this, this.getGuiLeft() + 4, this.getGuiTop() + 112);
        this.zoomWidget = new ZoomWidget(this, this.getGuiLeft() + 4, this.getGuiTop() + 142);
        this.tabsWidget = new TabsWidget(this, this.getGuiLeft() + 4, this.getGuiTop() + 158);
        this.helpWidget = new HelpWidget(this, this.getGuiLeft() + 197, this.getGuiTop() + 0);
        this.addPaintingWidget(this.canvasWidget);
        this.addPaintingWidget(this.paletteWidget);
        this.addPaintingWidget(this.toolsWidget);
        this.addPaintingWidget(this.historyWidget);
        this.addPaintingWidget(this.zoomWidget);
        this.addPaintingWidget(this.tabsWidget);
        this.addPaintingWidget(this.helpWidget);
        this.tabs = new HashMap();
        ColorTab colorTab = new ColorTab(this, this.getGuiLeft(), this.getGuiTop());
        PencilParametersTab pencilParametersTab = new PencilParametersTab(this, this.getGuiLeft(), this.getGuiTop());
        BrushParametersTab brushParametersTab = new BrushParametersTab(this, this.getGuiLeft(), this.getGuiTop());
        BucketParametersTab bucketParametersTab = new BucketParametersTab(this, this.getGuiLeft(), this.getGuiTop());
        InventoryTab inventoryTab = new InventoryTab(this, this.getGuiLeft(), this.getGuiTop());
        this.tabs.put(TabsWidget.Tab.COLOR, colorTab);
        this.tabs.put(TabsWidget.Tab.PENCIL_PARAMETERS, pencilParametersTab);
        this.tabs.put(TabsWidget.Tab.BRUSH_PARAMETERS, brushParametersTab);
        this.tabs.put(TabsWidget.Tab.BUCKET_PARAMETERS, bucketParametersTab);
        this.tabs.put(TabsWidget.Tab.INVENTORY, inventoryTab);
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        ((EaselMenu)this.f_97732_).addToolUpdateListener(this::updateCurrentTool);
        ((EaselMenu)this.f_97732_).addColorUpdateListener(this::updateCurrentColor);
        ((EaselMenu)this.f_97732_).m_38893_(this);
        Tools.EYEDROPPER.getTool().addActionListener(this);
        Tools.HAND.getTool().addActionListener(this);
    }

    public void addPaintingWidget(AbstractPaintingWidget widget) {
        this.paintingWidgets.add(widget);
        this.m_7787_(widget);
    }

    public void updateCurrentTool(AbstractToolParameters parameters) {
        this.tabsWidget.updateTabs();
        ((EaselMenu)this.m_6262_()).setCurrentTab(TabsWidget.Tab.COLOR);
        switch (((EaselMenu)this.m_6262_()).getCurrentTool()) {
            case PENCIL: {
                ((PencilParametersTab)this.tabs.get((Object)TabsWidget.Tab.PENCIL_PARAMETERS)).update(parameters);
                break;
            }
            case BRUSH: {
                ((BrushParametersTab)this.tabs.get((Object)TabsWidget.Tab.BRUSH_PARAMETERS)).update(parameters);
                break;
            }
            case BUCKET: {
                ((BucketParametersTab)this.tabs.get((Object)TabsWidget.Tab.BUCKET_PARAMETERS)).update(parameters);
            }
        }
    }

    public void updateCurrentColor(Integer color) {
        ((ColorTab)this.tabs.get((Object)TabsWidget.Tab.COLOR)).update(color);
    }

    public <T extends GuiEventListener & NarratableEntry> void pipeWidget(T widget) {
        this.m_7787_(widget);
    }

    public void m_7861_() {
        super.m_7861_();
        ((EaselMenu)this.f_97732_).removeToolUpdateListener(this::updateCurrentTool);
        ((EaselMenu)this.f_97732_).removeColorUpdateListener(this::updateCurrentColor);
        ((EaselMenu)this.f_97732_).m_38943_(this);
        Tools.EYEDROPPER.getTool().removeActionListener(this);
        Tools.HAND.getTool().removeActionListener(this);
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public AbstractTab getCurrentTab() {
        return this.tabs.get((Object)((EaselMenu)this.m_6262_()).getCurrentTab());
    }

    public int getColorAt(int pixelIndex) {
        return ((EaselMenu)this.f_97732_).getCanvasData().getColorAt(pixelIndex);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PAINTING_RESOURCE);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.canvasWidget.m_6305_(matrixStack, x, y, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PAINTING_RESOURCE);
        this.toolsWidget.render(matrixStack);
        this.tabsWidget.render(matrixStack);
        this.historyWidget.render(matrixStack);
        this.zoomWidget.render(matrixStack);
        this.paletteWidget.render(matrixStack);
        this.helpWidget.m_6305_(matrixStack, x, y, partialTicks);
        this.getCurrentTab().m_6305_(matrixStack, x, y, partialTicks);
    }

    protected void m_7025_(PoseStack matrixStack, int x, int y) {
        super.m_7025_(matrixStack, x, y);
        for (AbstractPaintingWidget widget : this.paintingWidgets) {
            Component tooltip;
            if (!widget.m_5953_(x, y) || (tooltip = widget.getTooltip(x, y)) == null) continue;
            this.m_96602_(matrixStack, tooltip, x, y);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        int FONT_Y_SPACING = 12;
        int TAB_LABEL_XPOS = 37;
        int TAB_LABEL_YPOS = 144;
        this.f_96547_.m_92889_(matrixStack, ((EaselMenu)this.m_6262_()).getCurrentTab().translatableComponent, 37.0f, 144.0f, Color.darkGray.getRGB());
        this.getCurrentTab().renderLabels(matrixStack, mouseX, mouseY);
    }

    public void m_181908_() {
        super.m_181908_();
        this.canvasWidget.tick();
    }

    @Override
    public void useToolCallback(CanvasData canvas, AbstractTool<?> tool, AbstractToolParameters parameters, int color, float posX, float posY) {
        if (tool.equals(Tools.EYEDROPPER.getTool())) {
            int canvasPosX = (int)Math.min(Math.max(posX, 0.0f), (float)canvas.getWidth());
            int canvasPosY = (int)Math.min(Math.max(posY, 0.0f), (float)canvas.getHeight());
            int newColor = canvas.getColorAt(canvasPosX, canvasPosY);
            ((EaselMenu)this.m_6262_()).setPaletteColor(newColor);
        } else if (tool.equals(Tools.HAND.getTool())) {
            if (this.dragStart == null || this.dragCurrent == null || this.dragStartCanvasOffset == null) {
                return;
            }
            double dragX = this.dragStart[0] - this.dragCurrent[0];
            double dragY = this.dragStart[1] - this.dragCurrent[1];
            int offsetX = (int)Math.round(dragX);
            int offsetY = (int)Math.round(dragY);
            ((EaselMenu)this.m_6262_()).updateCanvasOffset(this.dragStartCanvasOffset[0] - offsetX, this.dragStartCanvasOffset[1] - offsetY);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.getCurrentTab().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 256: {
                assert (this.f_96541_ != null);
                assert (this.f_96541_.f_91074_ != null);
                this.f_96541_.f_91074_.m_6915_();
                return true;
            }
            case 80: {
                ((EaselMenu)this.m_6262_()).setCurrentTool(Tools.PENCIL);
                return true;
            }
            case 66: {
                ((EaselMenu)this.m_6262_()).setCurrentTool(Tools.BRUSH);
                return true;
            }
            case 73: {
                ((EaselMenu)this.m_6262_()).setCurrentTool(Tools.EYEDROPPER);
                return true;
            }
            case 342: {
                this.activateQuickTool(Tools.EYEDROPPER);
                return true;
            }
            case 70: {
                ((EaselMenu)this.m_6262_()).setCurrentTool(Tools.BUCKET);
                return true;
            }
            case 72: {
                ((EaselMenu)this.m_6262_()).setCurrentTool(Tools.HAND);
                return true;
            }
            case 32: {
                this.activateQuickTool(Tools.HAND);
                return true;
            }
            case 88: {
                int row = ((EaselMenu)this.m_6262_()).getCurrentPaletteSlot() / 2 * 2;
                int offset = ((EaselMenu)this.m_6262_()).getCurrentPaletteSlot() % 2 == 0 ? 1 : 0;
                ((EaselMenu)this.m_6262_()).setCurrentPaletteSlot(row + offset);
                return true;
            }
            case 265: {
                int row = ((EaselMenu)this.m_6262_()).getCurrentPaletteSlot() / 2;
                int offset = ((EaselMenu)this.m_6262_()).getCurrentPaletteSlot() % 2;
                if (row <= 0) {
                    return false;
                }
                ((EaselMenu)this.m_6262_()).setCurrentPaletteSlot((row - 1) * 2 + offset);
                return true;
            }
            case 45: {
                ((EaselMenu)this.m_6262_()).decreaseCanvasScale();
                return true;
            }
            case 61: {
                ((EaselMenu)this.m_6262_()).increaseCanvasScale();
                return true;
            }
            case 264: {
                int row = ((EaselMenu)this.m_6262_()).getCurrentPaletteSlot() / 2;
                int offset = ((EaselMenu)this.m_6262_()).getCurrentPaletteSlot() % 2;
                if (row >= 7) {
                    return false;
                }
                ((EaselMenu)this.m_6262_()).setCurrentPaletteSlot((row + 1) * 2 + offset);
                return true;
            }
            case 90: {
                if (Screen.m_96637_()) {
                    ((EaselMenu)this.m_6262_()).undo();
                    return true;
                }
            }
            case 89: {
                if (!Screen.m_96637_()) break;
                ((EaselMenu)this.m_6262_()).redo();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.getCurrentTab().m_7920_(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 32: 
            case 342: {
                this.deactivateQuickTool();
                return true;
            }
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.getCurrentTab().m_5534_(codePoint, modifiers);
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.dragStart == null) {
            this.dragStart = new double[]{mouseX, mouseY};
            this.dragStartCanvasOffset = new int[]{((EaselMenu)this.m_6262_()).getCanvasOffsetX(), ((EaselMenu)this.m_6262_()).getCanvasOffsetY()};
        }
        super.m_6375_(mouseX, mouseY, button);
        return this.getCurrentTab().m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.dragCurrent = new double[]{mouseX, mouseY};
        this.canvasWidget.m_7979_(mouseX, mouseY, button, dragX, dragY);
        this.getCurrentTab().m_7979_(mouseX, mouseY, button, dragX, dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.canvasWidget.m_6348_(mouseX, mouseY, button);
        this.getCurrentTab().m_6348_(mouseX, mouseY, button);
        if (this.dragStart != null || this.dragCurrent != null || this.dragStartCanvasOffset != null) {
            this.dragStart = null;
            this.dragStartCanvasOffset = null;
            this.dragCurrent = null;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (EaselScreen.m_96637_()) {
            AbstractToolParameters parameters;
            if (((EaselMenu)this.m_6262_()).getCurrentTool() == Tools.BRUSH) {
                AbstractToolParameters parameters2 = ((EaselMenu)this.m_6262_()).getCurrentToolParameters();
                if (parameters2 instanceof SizeParameterHolder) {
                    float newSize = ((SizeParameterHolder)((Object)parameters2)).getSize() + (float)delta;
                    newSize = Math.min(Math.max(newSize, 1.0f), 6.0f);
                    ((SizeParameterHolder)((Object)parameters2)).setSize(newSize);
                    return true;
                }
            } else if (((EaselMenu)this.m_6262_()).getCurrentTool() == Tools.PENCIL && (parameters = ((EaselMenu)this.m_6262_()).getCurrentToolParameters()) instanceof SizeParameterHolder) {
                float newSize = ((SizeParameterHolder)((Object)parameters)).getSize() + (float)(delta > 0.0 ? 1 : -1);
                newSize = Math.min(Math.max(newSize, 1.0f), 6.0f);
                ((SizeParameterHolder)((Object)parameters)).setSize(newSize);
                return true;
            }
        }
        return this.canvasWidget.m_6050_(mouseX, mouseY, delta);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
    }

    public void m_7934_(AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
        this.updateCurrentColor(((EaselMenu)this.m_6262_()).getCurrentColor());
    }

    public void activateQuickTool(Tools tool) {
        if (((EaselMenu)this.m_6262_()).getCurrentTool() != tool) {
            this.quickToolCache = ((EaselMenu)this.m_6262_()).getCurrentTool();
            ((EaselMenu)this.m_6262_()).setCurrentTool(tool);
        }
    }

    public void deactivateQuickTool() {
        if (this.quickToolCache != null) {
            ((EaselMenu)this.m_6262_()).setCurrentTool(this.quickToolCache);
            this.quickToolCache = null;
        }
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }
}

