/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.SizeParameterHolder;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;

public class CanvasWidget
extends AbstractPaintingWidget
implements Widget {
    public static final int SIZE = 128;
    public static final ResourceLocation PAINTING_CHECKER_RESOURCE = new ResourceLocation("zetter", "textures/gui/easel/checker.png");
    private boolean canvasDragging = false;
    private double scrollDistance = 0.0;
    private long scrollTimestamp = 0L;

    public CanvasWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 128, 128, (Component)Component.m_237115_((String)"container.zetter.painting.canvas"));
    }

    private int getCanvasScale() {
        return ((EaselMenu)this.parentScreen.m_6262_()).getCanvasScaleFactor() * 2;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.canvasDragging = true;
            this.handleCanvasInteraction(mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.canvasDragging) {
                this.handleCanvasInteraction(mouseX, mouseY);
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.canvasDragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.scrollDistance += delta;
            this.scrollTimestamp = System.currentTimeMillis();
            if (this.scrollDistance <= -1.5) {
                ((EaselMenu)this.parentScreen.m_6262_()).decreaseCanvasScale();
                this.scrollDistance = 0.0;
            } else if (this.scrollDistance >= 1.5) {
                ((EaselMenu)this.parentScreen.m_6262_()).increaseCanvasScale();
                this.scrollDistance = 0.0;
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.scrollDistance != 0.0 && System.currentTimeMillis() - this.scrollTimestamp > 1500L) {
            this.scrollDistance = 0.0;
        }
    }

    protected boolean handleCanvasInteraction(double mouseX, double mouseY) {
        float canvasX = (float)((mouseX - (double)this.f_93620_ - (double)((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX()) / (double)this.getCanvasScale());
        float canvasY = (float)((mouseY - (double)this.f_93621_ - (double)((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY()) / (double)this.getCanvasScale());
        ((EaselMenu)this.parentScreen.m_6262_()).useTool(canvasX, canvasY);
        return true;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!((EaselMenu)this.parentScreen.m_6262_()).isCanvasAvailable()) {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
            return;
        }
        int scale = (int)this.parentScreen.getMinecraft().m_91268_().m_85449_();
        int windowHeight = this.parentScreen.getMinecraft().m_91268_().m_85442_();
        RenderSystem.m_69488_((int)(this.f_93620_ * scale), (int)(windowHeight - (this.f_93621_ + this.f_93619_) * scale), (int)(this.f_93618_ * scale), (int)(this.f_93619_ * scale));
        this.renderCheckerboard(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EaselScreen.PAINTING_RESOURCE);
        String canvasCode = ((EaselMenu)this.parentScreen.m_6262_()).getCanvasCode();
        CanvasData canvasData = ((EaselMenu)this.parentScreen.m_6262_()).getCanvasData();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.f_93620_ + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX()), (double)(this.f_93621_ + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY()), 1.0);
        matrixStack.m_85841_((float)this.getCanvasScale(), (float)this.getCanvasScale(), 1.0f);
        MultiBufferSource.BufferSource renderTypeBufferImpl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        CanvasRenderer.getInstance().renderCanvas(matrixStack, (MultiBufferSource)renderTypeBufferImpl, canvasCode, canvasData, 0xF000F0);
        renderTypeBufferImpl.m_109911_();
        matrixStack.m_85849_();
        if (mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_) {
            if (((EaselMenu)this.parentScreen.m_6262_()).getCurrentTool().getTool() == Tools.HAND.getTool()) {
                GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
            } else {
                double canvasX = (double)(mouseX - this.f_93620_ - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX()) / (double)this.getCanvasScale();
                double canvasY = (double)(mouseY - this.f_93621_ - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY()) / (double)this.getCanvasScale();
                this.renderCursor(matrixStack, canvasX, canvasY);
            }
        } else {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
        }
        RenderSystem.m_69471_();
    }

    private void renderCheckerboard(PoseStack matrixStack) {
        int offsetX = Math.abs(this.getCanvasScale() * 2 - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX() % (this.getCanvasScale() * 2));
        int offsetY = Math.abs(this.getCanvasScale() * 2 - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY() % (this.getCanvasScale() * 2));
        int width = this.f_93618_ + this.getCanvasScale() * 4;
        int height = this.f_93619_ + this.getCanvasScale() * 4;
        float x1 = this.f_93620_ - offsetX;
        float x2 = x1 + (float)width;
        float y1 = this.f_93621_ - offsetY;
        float y2 = y1 + (float)height;
        float uvScale = (float)this.getCanvasScale() * 2.0f;
        float u1 = 0.0f;
        float u2 = (float)width / uvScale;
        float v1 = 0.0f;
        float v2 = (float)height / uvScale;
        matrixStack.m_85836_();
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PAINTING_CHECKER_RESOURCE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, x1, y2, (float)this.m_93252_()).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_85982_(matrix, x2, y2, (float)this.m_93252_()).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_85982_(matrix, x2, y1, (float)this.m_93252_()).m_7421_(u2, v1).m_5752_();
        bufferBuilder.m_85982_(matrix, x1, y1, (float)this.m_93252_()).m_7421_(u1, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        matrixStack.m_85849_();
    }

    private void renderCursor(PoseStack matrixStack, double canvasX, double canvasY) {
        AbstractToolParameters toolParameters = ((EaselMenu)this.parentScreen.m_6262_()).getCurrentToolParameters();
        AbstractTool.ToolShape shape = ((EaselMenu)this.parentScreen.m_6262_()).getCurrentTool().getTool().getShape(toolParameters);
        RenderSystem.m_69403_((int)32778);
        if (shape == null) {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212994);
            int radius = this.getCanvasScale() * 2;
            if (toolParameters instanceof SizeParameterHolder) {
                radius = Math.round((float)this.getCanvasScale() * ((SizeParameterHolder)((Object)toolParameters)).getSize());
            }
            if (radius < 4) {
                radius = 4;
            }
            int globalX = this.f_93620_ + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX() + (int)Math.floor(canvasX * (double)this.getCanvasScale()) - 1;
            int globalY = this.f_93621_ + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY() + (int)Math.floor(canvasY * (double)this.getCanvasScale()) - 1;
            this.m_93154_(matrixStack, globalX - radius, globalX - 2, globalY, -2139062144);
            this.m_93154_(matrixStack, globalX + radius, globalX + 2, globalY, -2139062144);
            this.m_93222_(matrixStack, globalX, globalY - radius, globalY - 2, -2139062144);
            this.m_93222_(matrixStack, globalX, globalY + radius, globalY + 2, -2139062144);
        } else {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
            int offset = -(shape.getSize() / 2);
            int globalX = this.f_93620_ + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX() + (int)Math.floor(canvasX) * this.getCanvasScale();
            int globalY = this.f_93621_ + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY() + (int)Math.floor(canvasY) * this.getCanvasScale();
            for (AbstractTool.ShapeLine line : shape.getLines()) {
                int posX = (line.posX() + offset) * this.getCanvasScale();
                int posY = (line.posY() + offset) * this.getCanvasScale();
                int length = line.length() * this.getCanvasScale();
                if (line.direction() == AbstractTool.ShapeLine.LineDirection.HORIZONTAL) {
                    if (posX <= 0 && --posX + length > 0) {
                        ++length;
                    }
                    if (posY <= 0) {
                        --posY;
                    }
                    int minX = globalX + posX;
                    this.m_93154_(matrixStack, minX, minX + length, globalY + posY, -2139062144);
                    continue;
                }
                if (posX <= 0) {
                    --posX;
                }
                if (posY <= 0 && --posY + length > 0) {
                    ++length;
                }
                int minY = globalY + posY;
                this.m_93222_(matrixStack, globalX + posX, minY, minY + length, -2139062144);
            }
        }
        RenderSystem.m_69403_((int)32774);
    }
}

