/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.DitheringParameterHolder;
import me.dantaeusb.zetter.painting.pipes.DitheringPipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DitheringWidget
extends AbstractPaintingWidget
implements Widget {
    private static final int WIDTH = 80;
    private static final int HEIGHT = 32;
    private static final int FONT_Y_MARGIN = 12;
    private static final int DITHERING_BUTTON_WIDTH = 20;
    private static final int DITHERING_BUTTON_HEIGHT = 20;
    private final List<DitheringButton> buttons;

    public DitheringWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 80, 32, (Component)Component.m_237115_((String)"container.zetter.painting.dithering"));
        boolean DITHERING_BUTTON_U = false;
        int DITHERING_BUTTON_V = 32;
        this.buttons = new ArrayList<DitheringButton>(){
            {
                this.add(new DitheringButton(DitheringPipe.DitheringOption.NO_DITHERING, 0, 32, 20, 20));
                this.add(new DitheringButton(DitheringPipe.DitheringOption.DENSE_DITHERING, 20, 32, 20, 20));
            }
        };
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (DitheringButton ditheringButton : this.buttons) {
            int fromX = this.f_93620_ + i * 20;
            if (EaselScreen.isInRect(fromX, this.f_93621_ + 12, ditheringButton.width, ditheringButton.height, iMouseX, iMouseY) && this.m_7972_(button)) {
                AbstractToolParameters parameters = ((EaselMenu)this.parentScreen.m_6262_()).getCurrentToolParameters();
                if (!(parameters instanceof DitheringParameterHolder)) {
                    throw new RuntimeException("Cannot apply blending parameter");
                }
                ((DitheringParameterHolder)((Object)parameters)).setDithering(ditheringButton.dithering);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void render(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractPaintingWidget.PAINTING_WIDGETS_RESOURCE);
        AbstractToolParameters parameters = ((EaselMenu)this.parentScreen.m_6262_()).getCurrentToolParameters();
        DitheringPipe.DitheringOption dithering = null;
        if (!(parameters instanceof DitheringParameterHolder)) {
            throw new RuntimeException("Cannot render dithering parameter");
        }
        dithering = ((DitheringParameterHolder)((Object)parameters)).getDithering();
        int i = 0;
        for (DitheringButton ditheringButton : this.buttons) {
            int fromX = this.f_93620_ + i * 20;
            int vOffset = dithering == ditheringButton.dithering ? 20 : 0;
            this.m_93228_(matrixStack, fromX, this.f_93621_ + 12, ditheringButton.uPosition, ditheringButton.vPosition + vOffset, ditheringButton.width, ditheringButton.height);
            ++i;
        }
    }

    @Override
    public void renderLabels(PoseStack matrixStack, int mouseX, int mouseY) {
        this.parentScreen.getFont().m_92889_(matrixStack, this.m_6035_(), (float)this.f_93620_ - (float)this.parentScreen.getGuiLeft(), (float)this.f_93621_ - (float)this.parentScreen.getGuiTop(), Color.DARK_GRAY.getRGB());
    }

    public class DitheringButton {
        private final DitheringPipe.DitheringOption dithering;
        public final int uPosition;
        public final int vPosition;
        public final int height;
        public final int width;

        DitheringButton(DitheringPipe.DitheringOption dithering, int uPosition, int vPosition, int width, int height) {
            this.dithering = dithering;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
            this.height = height;
            this.width = width;
        }

        public Component getTooltip() {
            return this.dithering.translatableComponent;
        }
    }
}

