/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.painting.Tools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ToolsWidget
extends AbstractPaintingWidget
implements Widget {
    private final List<ToolButton> buttons = new ArrayList<ToolButton>(){
        {
            this.add(new ToolButton(Tools.PENCIL, 209, 116, 22, 16));
            this.add(new ToolButton(Tools.BRUSH, 209, 132, 22, 16));
            this.add(new ToolButton(Tools.EYEDROPPER, 209, 148, 22, 16));
            this.add(new ToolButton(Tools.BUCKET, 209, 164, 22, 16));
            this.add(new ToolButton(Tools.HAND, 209, 180, 22, 16));
        }
    };
    static final int TOOL_BUTTON_WIDTH = 22;
    static final int TOOL_BUTTON_HEIGHT = 16;
    static final int TOOL_BUTTONS_U = 209;
    static final int TOOL_BUTTONS_V = 116;

    public ToolsWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 24, 82, (Component)Component.m_237115_((String)"container.zetter.painting.tools"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        int i = 0;
        for (ToolButton toolButton : this.buttons) {
            int fromY = this.f_93621_ + 1 + i * 16;
            if (EaselScreen.isInRect(this.f_93620_ + 1, fromY, 22, 16, mouseX, mouseY)) {
                return toolButton.getTooltip();
            }
            ++i;
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (ToolButton toolButton : this.buttons) {
            int fromY = this.f_93621_ + 1 + i * 16;
            if (EaselScreen.isInRect(this.f_93620_, fromY, toolButton.width, toolButton.height, iMouseX, iMouseY) && this.m_7972_(button)) {
                this.updateCurrentTool(toolButton);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void render(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractPaintingWidget.PAINTING_WIDGETS_RESOURCE);
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 184, 115, 24, 16 * this.buttons.size() + 2);
        if (((EaselMenu)this.parentScreen.m_6262_()).getCanvasData() == null || ((EaselMenu)this.parentScreen.m_6262_()).getContainer().getPaletteStack().m_41619_()) {
            return;
        }
        int i = 0;
        for (ToolButton toolButton : this.buttons) {
            int fromY = this.f_93621_ + 1 + i * 16;
            int uOffset = toolButton.uPosition + (((EaselMenu)this.parentScreen.m_6262_()).getCurrentTool() == toolButton.tool ? 24 : 0);
            this.m_93228_(matrixStack, this.f_93620_ + 1, fromY, uOffset, toolButton.vPosition, toolButton.width, toolButton.height);
            ++i;
        }
    }

    protected void updateCurrentTool(ToolButton toolButton) {
        ((EaselMenu)this.parentScreen.m_6262_()).setCurrentTool(toolButton.tool);
    }

    public class ToolButton {
        public final Tools tool;
        public final int uPosition;
        public final int vPosition;
        public final int height;
        public final int width;

        ToolButton(Tools tool, int uPosition, int vPosition, int width, int height) {
            this.tool = tool;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
            this.height = height;
            this.width = width;
        }

        public Component getTooltip() {
            return this.tool.getTool().getTranslatableComponent();
        }
    }
}

