/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ZoomWidget
extends AbstractPaintingWidget
implements Widget {
    private final List<ZoomButton> buttons;
    public static final int ZOOM_OUT_HOTKEY = 45;
    public static final int ZOOM_IN_HOTKEY = 61;
    static final int ZOOM_BUTTON_WIDTH = 12;
    static final int ZOOM_BUTTON_HEIGHT = 12;
    static final int ZOOM_BUTTONS_U = 208;
    static final int ZOOM_BUTTONS_V = 197;

    public ZoomWidget(final EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 24, 12, (Component)Component.m_237115_((String)"container.zetter.painting.zoom"));
        this.buttons = new ArrayList<ZoomButton>(){
            {
                this.add(new ZoomButton(((EaselMenu)parentScreen.m_6262_())::canIncreaseCanvasScale, ((EaselMenu)parentScreen.m_6262_())::increaseCanvasScale, 208, 197, 12, 12, (Component)Component.m_237115_((String)"container.zetter.painting.zoom.in")));
                this.add(new ZoomButton(((EaselMenu)parentScreen.m_6262_())::canDecreaseCanvasScale, ((EaselMenu)parentScreen.m_6262_())::decreaseCanvasScale, 220, 197, 12, 12, (Component)Component.m_237115_((String)"container.zetter.painting.zoom.out")));
            }
        };
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        int i = 0;
        for (ZoomButton zoomButton : this.buttons) {
            int fromX = this.f_93620_ + i * 12;
            if (EaselScreen.isInRect(fromX, this.f_93621_, 12, 12, mouseX, mouseY)) {
                return zoomButton.getTooltip();
            }
            ++i;
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (ZoomButton zoomButton : this.buttons) {
            int fromX = this.f_93620_ + i * 12;
            if (EaselScreen.isInRect(fromX, this.f_93621_, 12, 12, iMouseX, iMouseY)) {
                zoomButton.action.get();
                this.m_7435_(Minecraft.m_91087_().m_91106_());
            }
            ++i;
        }
        return false;
    }

    public void render(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractPaintingWidget.PAINTING_WIDGETS_RESOURCE);
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 184, 197, 12 * this.buttons.size(), 12);
        int i = 0;
        for (ZoomButton zoomButton : this.buttons) {
            int fromX = this.f_93620_ + i * 12;
            int uOffset = zoomButton.uPosition + (zoomButton.active.get() != false ? 0 : 24);
            this.m_93228_(matrixStack, fromX, this.f_93621_, uOffset, zoomButton.vPosition, zoomButton.width, zoomButton.height);
            ++i;
        }
    }

    public boolean undo() {
        return false;
    }

    public boolean redo() {
        return false;
    }

    public class ZoomButton {
        public final Supplier<Boolean> active;
        public final Supplier<Boolean> action;
        public final int uPosition;
        public final int vPosition;
        public final int height;
        public final int width;
        public final Component label;

        ZoomButton(Supplier<Boolean> active, Supplier<Boolean> action, int uPosition, int vPosition, int width, int height, Component label) {
            this.active = active;
            this.action = action;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
            this.height = height;
            this.width = width;
            this.label = label;
        }

        public Component getTooltip() {
            return this.label;
        }
    }
}

