/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import java.util.HashMap;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterBlocks;
import me.dantaeusb.zetter.entity.item.PaintingEntity;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.EaselItem;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.item.PaintsItem;
import me.dantaeusb.zetter.item.PaletteItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ZetterItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"zetter");
    public static final RegistryObject<EaselItem> EASEL = ITEMS.register("easel", () -> new EaselItem());
    public static final RegistryObject<BlockItem> ARTIST_TABLE = ITEMS.register("artist_table", () -> new BlockItem((Block)ZetterBlocks.ARTIST_TABLE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40756_)));
    public static final RegistryObject<CanvasItem> CANVAS = ITEMS.register("canvas", () -> new CanvasItem(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_)));
    public static final RegistryObject<PaintingItem> PAINTING = ITEMS.register("painting", () -> new PaintingItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<PaintsItem> PAINTS = ITEMS.register("paints", () -> new PaintsItem());
    public static final RegistryObject<PaletteItem> PALETTE = ITEMS.register("palette", () -> new PaletteItem());
    public static final HashMap<String, RegistryObject<FrameItem>> FRAMES = new HashMap();
    public static final RegistryObject<FrameItem> ACACIA_FRAME = ZetterItems.registerFrame("acacia_basic_frame", PaintingEntity.Materials.ACACIA, false);
    public static final RegistryObject<FrameItem> BIRCH_FRAME = ZetterItems.registerFrame("birch_basic_frame", PaintingEntity.Materials.BIRCH, false);
    public static final RegistryObject<FrameItem> DARK_OAK_FRAME = ZetterItems.registerFrame("dark_oak_basic_frame", PaintingEntity.Materials.DARK_OAK, false);
    public static final RegistryObject<FrameItem> JUNGLE_FRAME = ZetterItems.registerFrame("jungle_basic_frame", PaintingEntity.Materials.JUNGLE, false);
    public static final RegistryObject<FrameItem> OAK_FRAME = ZetterItems.registerFrame("oak_basic_frame", PaintingEntity.Materials.OAK, false);
    public static final RegistryObject<FrameItem> SPRUCE_FRAME = ZetterItems.registerFrame("spruce_basic_frame", PaintingEntity.Materials.SPRUCE, false);
    public static final RegistryObject<FrameItem> MANGROVE_FRAME = ZetterItems.registerFrame("mangrove_basic_frame", PaintingEntity.Materials.MANGROVE, false);
    public static final RegistryObject<FrameItem> CRIMSON_FRAME = ZetterItems.registerFrame("crimson_basic_frame", PaintingEntity.Materials.CRIMSON, false);
    public static final RegistryObject<FrameItem> WARPED_FRAME = ZetterItems.registerFrame("warped_basic_frame", PaintingEntity.Materials.WARPED, false);
    public static final RegistryObject<FrameItem> ACACIA_PLATED_FRAME = ZetterItems.registerFrame("acacia_plated_frame", PaintingEntity.Materials.ACACIA, true);
    public static final RegistryObject<FrameItem> BIRCH_PLATED_FRAME = ZetterItems.registerFrame("birch_plated_frame", PaintingEntity.Materials.BIRCH, true);
    public static final RegistryObject<FrameItem> DARK_OAK_PLATED_FRAME = ZetterItems.registerFrame("dark_oak_plated_frame", PaintingEntity.Materials.DARK_OAK, true);
    public static final RegistryObject<FrameItem> JUNGLE_PLATED_FRAME = ZetterItems.registerFrame("jungle_plated_frame", PaintingEntity.Materials.JUNGLE, true);
    public static final RegistryObject<FrameItem> OAK_PLATED_FRAME = ZetterItems.registerFrame("oak_plated_frame", PaintingEntity.Materials.OAK, true);
    public static final RegistryObject<FrameItem> SPRUCE_PLATED_FRAME = ZetterItems.registerFrame("spruce_plated_frame", PaintingEntity.Materials.SPRUCE, true);
    public static final RegistryObject<FrameItem> MANGROVE_PLATED_FRAME = ZetterItems.registerFrame("mangrove_plated_frame", PaintingEntity.Materials.MANGROVE, true);
    public static final RegistryObject<FrameItem> CRIMSON_PLATED_FRAME = ZetterItems.registerFrame("crimson_plated_frame", PaintingEntity.Materials.CRIMSON, true);
    public static final RegistryObject<FrameItem> WARPED_PLATED_FRAME = ZetterItems.registerFrame("warped_plated_frame", PaintingEntity.Materials.WARPED, true);
    public static final RegistryObject<FrameItem> IRON_FRAME = ZetterItems.registerFrame("iron_frame", PaintingEntity.Materials.IRON, false);
    public static final RegistryObject<FrameItem> GOLD_FRAME = ZetterItems.registerFrame("gold_basic_frame", PaintingEntity.Materials.GOLD, false);
    public static final RegistryObject<FrameItem> GOLD_PLATE_FRAME = ZetterItems.registerFrame("gold_plated_frame", PaintingEntity.Materials.GOLD, true);

    private static RegistryObject<FrameItem> registerFrame(String name, PaintingEntity.Materials material, boolean plated) {
        RegistryObject frameRegistryObject = ITEMS.register(name, () -> new FrameItem(new Item.Properties().m_41487_(64).m_41491_(CreativeModeTab.f_40756_), material, plated));
        FRAMES.put(Helper.getFrameKey(material, plated), (RegistryObject<FrameItem>)frameRegistryObject);
        return frameRegistryObject;
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }
}

