/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network;

import java.security.InvalidParameterException;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.entity.item.state.representation.CanvasAction;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.network.packet.CArtistTableModeChangePacket;
import me.dantaeusb.zetter.network.packet.CCanvasActionPacket;
import me.dantaeusb.zetter.network.packet.CCanvasHistoryActionPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestExportPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestViewPacket;
import me.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import me.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import me.dantaeusb.zetter.network.packet.CSignPaintingPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncExportErrorPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncExportPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncViewPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class ServerHandler {
    @Nullable
    private static AbstractCanvasData getAndTrackCanvasDataFromRequest(String canvasName, ServerPlayer sendingPlayer) {
        MinecraftServer server = sendingPlayer.m_9236_().m_7654_();
        ServerLevel level = server.m_129783_();
        CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker((Level)level);
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return null;
        }
        canvasTracker.trackCanvas(sendingPlayer.m_20148_(), canvasName);
        Object canvasData = canvasTracker.getCanvasData(canvasName);
        if (canvasData == null) {
            Zetter.LOG.error("Player " + sendingPlayer + " requested non-existent canvas: " + canvasName);
            return null;
        }
        return canvasData;
    }

    public static void processCanvasRequest(CCanvasRequestPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            AbstractCanvasData canvasData = ServerHandler.getAndTrackCanvasDataFromRequest(packetIn.canvasName, sendingPlayer);
            String canvasName = packetIn.canvasName;
            if (canvasData == null) {
                Zetter.LOG.warn("No canvas data found, not answering request for " + canvasName);
                return;
            }
            SCanvasSyncPacket<AbstractCanvasData> canvasSyncMessage = new SCanvasSyncPacket<AbstractCanvasData>(canvasName, canvasData, System.currentTimeMillis());
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), canvasSyncMessage);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasViewRequest(CCanvasRequestViewPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            AbstractCanvasData canvasData = ServerHandler.getAndTrackCanvasDataFromRequest(packetIn.canvasName, sendingPlayer);
            String canvasName = packetIn.canvasName;
            if (canvasData == null) {
                Zetter.LOG.warn("No canvas data found, not answering view request for " + canvasName);
                return;
            }
            SCanvasSyncViewPacket<AbstractCanvasData> canvasSyncViewMessage = new SCanvasSyncViewPacket<AbstractCanvasData>(canvasName, canvasData, System.currentTimeMillis(), packetIn.getHand());
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), canvasSyncViewMessage);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasExportRequest(CCanvasRequestExportPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            MinecraftServer server = sendingPlayer.m_9236_().m_7654_();
            ServerLevel level = server.m_129783_();
            CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker((Level)level);
            if (canvasTracker == null) {
                Zetter.LOG.error("Cannot find world canvas capability");
                SCanvasSyncExportErrorPacket canvasSyncExportErrorMessage = new SCanvasSyncExportErrorPacket("console.zetter.error.unknown", null);
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncExportErrorMessage);
                return;
            }
            String canvasCode = packetIn.requestCode;
            if (canvasCode == null) {
                canvasCode = Helper.lookupPaintingCodeByName(packetIn.requestTitle, (Level)level);
            }
            if (canvasCode == null) {
                SCanvasSyncExportErrorPacket canvasSyncExportErrorMessage = new SCanvasSyncExportErrorPacket("console.zetter.error.painting_not_found", packetIn.requestTitle);
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncExportErrorMessage);
                return;
            }
            PaintingData paintingData = (PaintingData)((Object)canvasTracker.getCanvasData(canvasCode));
            if (paintingData == null) {
                SCanvasSyncExportErrorPacket canvasSyncExportErrorMessage = new SCanvasSyncExportErrorPacket("console.zetter.error.painting_not_found", canvasCode);
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncExportErrorMessage);
                return;
            }
            SCanvasSyncExportPacket canvasSyncExportMessage = new SCanvasSyncExportPacket(canvasCode, paintingData, System.currentTimeMillis());
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncExportMessage);
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            SCanvasSyncExportErrorPacket canvasSyncExportErrorMessage = new SCanvasSyncExportErrorPacket("console.zetter.error.unknown", null);
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncExportErrorMessage);
            throw e;
        }
    }

    public static void processUnloadRequest(CCanvasUnloadRequestPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            MinecraftServer server = sendingPlayer.m_9236_().m_7654_();
            ServerLevel level = server.m_129783_();
            CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker((Level)level);
            Zetter.LOG.debug("Got request to unload canvas " + packetIn.getCanvasName() + " from " + sendingPlayer.m_20148_());
            if (canvasTracker == null) {
                Zetter.LOG.error("Cannot find world canvas capability");
                return;
            }
            canvasTracker.stopTrackingCanvas(sendingPlayer.m_20148_(), packetIn.getCanvasName());
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processPaletteUpdate(CPaletteUpdatePacket packetIn, ServerPlayer sendingPlayer) {
        try {
            if (sendingPlayer.f_36096_ instanceof EaselMenu) {
                EaselMenu paintingContainer = (EaselMenu)sendingPlayer.f_36096_;
                paintingContainer.setPaletteColor(packetIn.getColor(), packetIn.getSlotIndex());
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processSignPainting(CSignPaintingPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            int slot = packetIn.getSlot();
            if (Inventory.m_36045_((int)slot) || slot == 40) {
                ItemStack canvasStack = sendingPlayer.m_150109_().m_8020_(slot);
                if (!canvasStack.m_150930_((Item)ZetterItems.CANVAS.get())) {
                    Zetter.LOG.error("Unable to process painting signature - item in slot is not a canvas");
                    return;
                }
                CanvasData canvasData = CanvasItem.getCanvasData(canvasStack, (Level)sendingPlayer.m_9236_());
                if (canvasData == null) {
                    Zetter.LOG.error("Unable to process painting signature - canvas data is empty");
                    return;
                }
                ItemStack paintingStack = ServerHandler.createPainting((Player)sendingPlayer, packetIn.getPaintingTitle(), canvasData);
                sendingPlayer.m_150109_().m_6836_(slot, paintingStack);
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    private static ItemStack createPainting(Player player, String paintingTitle, CanvasData canvasData) {
        try {
            if (player.m_9236_().m_5776_()) {
                throw new InvalidParameterException("Create painting called on client");
            }
            CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker(player.m_9236_());
            ItemStack outStack = new ItemStack((ItemLike)ZetterItems.PAINTING.get());
            int newId = canvasTracker.getFreePaintingId();
            String newCode = PaintingData.getCanvasCode(newId);
            PaintingData paintingData = (PaintingData)((Object)((CanvasDataType)ZetterCanvasTypes.PAINTING.get()).createWrap(canvasData.getResolution(), canvasData.getWidth(), canvasData.getHeight(), canvasData.getColorData()));
            paintingData.setMetaProperties(player.m_20148_(), player.m_7755_().getString(), paintingTitle);
            canvasTracker.registerCanvasData(newCode, paintingData);
            PaintingItem.storePaintingData(outStack, newCode, paintingData, 0);
            return outStack;
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processAction(CCanvasActionPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            EaselEntity easelEntity = (EaselEntity)sendingPlayer.m_9236_().m_6815_(packetIn.easelEntityId);
            for (CanvasAction actionBuffer : packetIn.paintingActions) {
                actionBuffer.setAuthorUUID(sendingPlayer.m_20148_());
            }
            if (easelEntity != null) {
                easelEntity.getStateHandler().processActionServer(packetIn.paintingActions);
            } else {
                Zetter.LOG.warn("Unable to find entity " + packetIn.easelEntityId + " disregarding canvas changes");
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processCanvasHistory(CCanvasHistoryActionPacket packetIn, ServerPlayer sendingPlayer) {
        try {
            EaselEntity easelEntity = (EaselEntity)sendingPlayer.m_9236_().m_6815_(packetIn.easelEntityId);
            if (easelEntity != null) {
                if (packetIn.canceled) {
                    easelEntity.getStateHandler().undo(packetIn.actionId);
                } else {
                    easelEntity.getStateHandler().redo(packetIn.actionId);
                }
            } else {
                Zetter.LOG.warn("Unable to find entity " + packetIn.easelEntityId + " disregarding canvas changes");
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }

    public static void processArtistTableModeChange(CArtistTableModeChangePacket packetIn, ServerPlayer sendingPlayer) {
        try {
            if (sendingPlayer.f_36096_ instanceof ArtistTableMenu) {
                ArtistTableMenu artistTableMenu = (ArtistTableMenu)sendingPlayer.f_36096_;
                artistTableMenu.setMode(packetIn.getMode());
            }
        }
        catch (Exception e) {
            Zetter.LOG.error(e.getMessage());
            throw e;
        }
    }
}

