/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.network.ClientHandler;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SCanvasSyncExportPacket
extends SCanvasSyncPacket<PaintingData> {
    public SCanvasSyncExportPacket(String canvasCode, PaintingData paintingData, long timestamp) {
        super(canvasCode, paintingData, timestamp);
    }

    public static SCanvasSyncExportPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String canvasCode = networkBuffer.m_130136_(128);
            long timestamp = networkBuffer.readLong();
            PaintingData canvasData = (PaintingData)((Object)((CanvasDataType)ZetterCanvasTypes.PAINTING.get()).readPacketData(networkBuffer));
            return new SCanvasSyncExportPacket(canvasCode, canvasData, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SCanvasSyncExportPacket: " + e);
            return null;
        }
    }

    @Override
    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(this.canvasCode, 128);
        networkBuffer.writeLong(this.timestamp);
        ((CanvasDataType)ZetterCanvasTypes.PAINTING.get()).writePacketData((PaintingData)this.canvasData, networkBuffer);
    }

    public static void handle(SCanvasSyncExportPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SCanvasSyncExportPacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processCanvasSyncExportError(packetIn, (Level)clientWorld.get()));
    }

    @Override
    public String toString() {
        return "SCanvasSyncViewMessage[canvas=" + this.canvasCode + ",timestamp=" + this.timestamp + "]";
    }
}

