/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.entity.item.state.representation.CanvasAction;
import me.dantaeusb.zetter.entity.item.state.representation.CanvasSnapshot;
import me.dantaeusb.zetter.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SEaselStateSyncPacket {
    public static final int MAX_ACTIONS = 50;
    public final int easelEntityId;
    public final String canvasCode;
    public final boolean sync;
    @Nullable
    public final CanvasSnapshot snapshot;
    @Nullable
    public final ArrayList<CanvasAction> unsyncedActions;

    public SEaselStateSyncPacket(int easelEntityId, String canvasCode, boolean sync, @Nullable CanvasSnapshot snapshot, @Nullable ArrayList<CanvasAction> unsyncedActions) {
        this.easelEntityId = easelEntityId;
        this.canvasCode = canvasCode;
        this.sync = sync;
        this.snapshot = snapshot;
        this.unsyncedActions = unsyncedActions;
        if (snapshot == null && (unsyncedActions == null || unsyncedActions.isEmpty())) {
            Zetter.LOG.error("Preparing empty easel sync packet");
        }
    }

    public static SEaselStateSyncPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            int actionBuffersCount;
            int easelEntityId = networkBuffer.readInt();
            String canvasCode = networkBuffer.m_130136_(128);
            boolean sync = networkBuffer.readBoolean();
            CanvasSnapshot snapshot = null;
            boolean hasSnapshot = networkBuffer.readBoolean();
            if (hasSnapshot) {
                int snapshotId = networkBuffer.readInt();
                int snapshotColorLength = networkBuffer.readInt();
                byte[] snapshotColor = networkBuffer.m_130101_(snapshotColorLength);
                long snapshotTimestamp = networkBuffer.readLong();
                snapshot = CanvasSnapshot.createNetworkSnapshot(snapshotId, snapshotColor, snapshotTimestamp);
            }
            if ((actionBuffersCount = networkBuffer.readInt()) == 0) {
                return new SEaselStateSyncPacket(easelEntityId, canvasCode, sync, snapshot, null);
            }
            ArrayList<CanvasAction> unsyncedActions = new ArrayList<CanvasAction>();
            for (int i = 0; i < actionBuffersCount; ++i) {
                CanvasAction action = CanvasAction.readPacketData(networkBuffer);
                if (action != null) {
                    unsyncedActions.add(action);
                    continue;
                }
                Zetter.LOG.error("Cannot retrieve actions from buffer");
            }
            return new SEaselStateSyncPacket(easelEntityId, canvasCode, sync, snapshot, unsyncedActions);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SEaselStateSync: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.writeInt(this.easelEntityId);
        networkBuffer.m_130072_(this.canvasCode, 128);
        networkBuffer.writeBoolean(this.sync);
        networkBuffer.writeBoolean(this.snapshot != null);
        if (this.snapshot != null) {
            networkBuffer.writeInt(this.snapshot.id);
            networkBuffer.writeInt(this.snapshot.colors.length);
            networkBuffer.m_130087_(this.snapshot.colors);
            networkBuffer.writeLong(this.snapshot.timestamp.longValue());
        }
        if (this.unsyncedActions != null && !this.unsyncedActions.isEmpty()) {
            networkBuffer.writeInt(this.unsyncedActions.size());
            for (CanvasAction actionBuffer : this.unsyncedActions) {
                CanvasAction.writePacketData(actionBuffer, networkBuffer);
            }
        } else {
            networkBuffer.writeInt(0);
        }
    }

    public static void handle(SEaselStateSyncPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SEaselStateSync context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processEaselStateSync(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SEaselStateSync[easel=" + this.easelEntityId + "painting=" + this.canvasCode + "]";
    }
}

