/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import owmii.powah.lib.block.IOwnable;
import owmii.powah.lib.logistics.energy.Energy;

public class EnderNetwork
extends class_18 {
    public static final EnderNetwork INSTANCE = new EnderNetwork();
    private static final String NAME = "powah_network";
    public static final int MAX_CHANNELS = 12;
    private final Map<UUID, ImmutableList<Energy>> map = new HashMap<UUID, ImmutableList<Energy>>();

    public static class_18.class_8645<EnderNetwork> factory() {
        return new class_18.class_8645(EnderNetwork::new, EnderNetwork::load, class_4284.field_45078);
    }

    public static EnderNetwork get(class_1937 level) {
        Preconditions.checkArgument((boolean)(level instanceof class_3218));
        return EnderNetwork.get(((class_3218)level).method_8503());
    }

    public static EnderNetwork get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_3218.field_25179);
        Objects.requireNonNull(overworld, "Server should have an overworld.");
        return (EnderNetwork)overworld.method_17983().method_17924(EnderNetwork.factory(), NAME);
    }

    private EnderNetwork() {
    }

    private static EnderNetwork load(class_2487 nbt, class_7225.class_7874 registryLookup) {
        EnderNetwork enderNetwork = new EnderNetwork();
        class_2499 listNBT = nbt.method_10554("network", 10);
        enderNetwork.map.clear();
        for (int i = 0; i < listNBT.size(); ++i) {
            class_2487 nbt1 = listNBT.method_10602(i);
            UUID uuid = nbt1.method_25926("owner_id");
            class_2499 listNBT1 = nbt1.method_10554("channels", 10);
            for (int j = 0; j < listNBT1.size(); ++j) {
                class_2487 nbt2 = listNBT1.method_10602(j);
                enderNetwork.getEnergy(uuid, j).read(nbt2, true, false);
            }
        }
        return enderNetwork;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 listNBT = new class_2499();
        this.map.forEach((uuid, list) -> {
            class_2487 nbt1 = new class_2487();
            nbt1.method_25927("owner_id", uuid);
            class_2499 listNBT1 = new class_2499();
            list.forEach(storage -> {
                class_2487 nbt2 = new class_2487();
                storage.write(nbt2, true, false);
                listNBT1.add((Object)nbt2);
            });
            nbt1.method_10566("channels", (class_2520)listNBT1);
            listNBT.add((Object)nbt1);
        });
        nbt.method_10566("network", (class_2520)listNBT);
        return nbt;
    }

    public class_2487 serialize(UUID uuid) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("channels", (class_2520)this.getChannels(uuid).stream().map(energy -> energy.write(true, false)).collect(Collectors.toCollection(class_2499::new)));
        return nbt;
    }

    public void deserialize(UUID uuid, class_2487 nbt) {
        class_2499 listNBT = nbt.method_10554("channels", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.getEnergy(uuid, i).read(listNBT.method_10602(i), true, false);
        }
    }

    public Energy getEnergy(IOwnable ownable, int channel) {
        if (ownable.getOwner() != null) {
            return this.getEnergy(ownable.getOwner().getId(), channel);
        }
        return Energy.create(0L);
    }

    public Energy getEnergy(UUID uuid, int channel) {
        if (channel < 12) {
            return (Energy)this.getChannels(uuid).get(channel);
        }
        return Energy.create(0L);
    }

    public void setEnergy(UUID uuid, int channel, Energy energy) {
        this.getEnergy(uuid, channel).clone(energy);
        this.method_80();
    }

    public ImmutableList<Energy> getChannels(IOwnable ownable) {
        if (ownable.getOwner() != null) {
            return this.getChannels(ownable.getOwner().getId());
        }
        return EnderNetwork.empty();
    }

    public ImmutableList<Energy> getChannels(UUID uuid) {
        return this.map.computeIfAbsent(uuid, k -> EnderNetwork.empty());
    }

    public static ImmutableList<Energy> empty() {
        return (ImmutableList)IntStream.range(0, 12).mapToObj(i -> Energy.create(0L)).collect(ImmutableList.toImmutableList());
    }
}

