/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.components.PowahComponents;
import owmii.powah.components.WrenchLink;
import owmii.powah.item.WrenchItem;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.client.handler.IHud;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Util;
import owmii.powah.lib.util.math.V3d;

public class EnergizingOrbBlock
extends AbstractBlock<IVariant.Single, EnergizingOrbBlock>
implements class_3737,
IWrenchable,
IHud {
    public EnergizingOrbBlock(class_4970.class_2251 properties) {
        super(properties);
        this.setStateProps(state -> (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11033));
        this.shapes.put(class_2350.field_11036, class_259.method_1072((class_265)EnergizingOrbBlock.box(3.5, 11.0, 3.5, 12.5, 1.77, 12.5), (class_265)EnergizingOrbBlock.box(2.5, 15.0, 2.5, 13.5, 16.0, 13.5), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11033, class_259.method_1072((class_265)EnergizingOrbBlock.box(3.5, 14.23, 3.5, 12.5, 5.0, 12.5), (class_265)EnergizingOrbBlock.box(2.5, 0.0, 2.5, 13.5, 1.0, 13.5), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11043, class_259.method_1072((class_265)EnergizingOrbBlock.box(3.5, 3.5, 14.23, 12.5, 12.5, 5.0), (class_265)EnergizingOrbBlock.box(2.5, 2.5, 0.0, 13.5, 13.5, 1.0), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11035, class_259.method_1072((class_265)EnergizingOrbBlock.box(3.5, 3.5, 11.0, 12.5, 12.5, 1.77), (class_265)EnergizingOrbBlock.box(2.5, 2.5, 15.0, 13.5, 13.5, 16.0), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11039, class_259.method_1072((class_265)EnergizingOrbBlock.box(14.23, 3.5, 3.5, 5.0, 12.5, 12.5), (class_265)EnergizingOrbBlock.box(0.0, 2.5, 2.5, 1.0, 13.5, 13.5), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11034, class_259.method_1072((class_265)EnergizingOrbBlock.box(11.0, 3.5, 3.5, 1.77, 12.5, 12.5), (class_265)EnergizingOrbBlock.box(15.0, 2.5, 2.5, 16.0, 13.5, 13.5), (class_247)class_247.field_1366));
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EnergizingOrbTile(pos, state);
    }

    public class_9062 method_55765(class_1799 held, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_2586 tileentity = world.method_8321(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            Inventory inv = orb.getInventory();
            class_1799 output = inv.getStackInSlot(0);
            class_1799 off = player.method_6079();
            if (held.method_7960() || !output.method_7960()) {
                if (!world.field_9236) {
                    player.method_31548().method_7398(inv.removeNext());
                }
                return class_9062.field_47728;
            }
            class_1799 copy = held.method_7972();
            copy.method_7939(1);
            if (!inv.addNext(copy).method_7960() && !player.method_7337()) {
                held.method_7934(1);
            }
            return class_9062.field_47728;
        }
        return super.method_55765(held, state, world, pos, player, hand, result);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        this.search(worldIn, pos);
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 tileentity = world.method_8321(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            return orb.getInventory().getNonEmptyStacks().size();
        }
        return super.method_9572(state, world, pos);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        int range = Powah.config().general.energizing_range;
        List<class_2338> list = class_2338.method_20437((class_2338)pos.method_10069(-range, -range, -range), (class_2338)pos.method_10069(range, range, range)).map(class_2338::method_10062).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.forEach(pos1 -> {
            class_2586 tileEntity1 = worldIn.method_8321(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && pos.equals((Object)((EnergizingRodTile)tileEntity1).getOrbPos())) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(class_2338.field_10980);
            }
        });
        list.forEach(pos1 -> {
            class_2680 state1 = worldIn.method_8320(pos1);
            if (state1.method_26204() instanceof EnergizingOrbBlock) {
                ((EnergizingOrbBlock)state1.method_26204()).search(worldIn, (class_2338)pos1);
            }
        });
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    public void search(class_1937 worldIn, class_2338 pos) {
        int range = Powah.config().general.energizing_range;
        List list = class_2338.method_20437((class_2338)pos.method_10069(-range, -range, -range), (class_2338)pos.method_10069(range, range, range)).map(class_2338::method_10062).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.stream().filter(p -> worldIn.method_8477(pos)).forEach(pos1 -> {
            class_2586 tileEntity1 = worldIn.method_8321(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && !((EnergizingRodTile)tileEntity1).hasOrb()) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(pos);
            }
        });
    }

    @Override
    public boolean onWrench(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_2350 side, WrenchMode mode, class_243 hit) {
        class_1799 stack;
        class_1792 class_17922;
        if (mode.link() && (class_17922 = (stack = player.method_5998(hand)).method_7909()) instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)class_17922;
            class_2586 tileEntity = world.method_8321(pos);
            if (tileEntity instanceof EnergizingOrbTile) {
                WrenchLink link = wrench.getLinkData(stack);
                link.rodPos().ifPresentOrElse(rodPos -> {
                    class_2586 tileEntity1 = world.method_8321(rodPos);
                    if (tileEntity1 instanceof EnergizingRodTile) {
                        EnergizingRodTile rod = (EnergizingRodTile)tileEntity1;
                        V3d v3d = V3d.from(rodPos);
                        if ((int)v3d.distance(pos) <= Powah.config().general.energizing_range) {
                            rod.setOrbPos(pos);
                            player.method_7353((class_2561)class_2561.method_43471((String)"chat.powah.wrench.link.done").method_27692(class_124.field_1065), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"chat.powah.wrench.link.fail").method_27692(class_124.field_1061), true);
                        }
                    }
                    stack.method_57379(PowahComponents.WRENCH_LINK, (Object)new WrenchLink(Optional.empty(), link.orbPos()));
                }, () -> {
                    stack.method_57379(PowahComponents.WRENCH_LINK, (Object)new WrenchLink(Optional.empty(), Optional.of(pos)));
                    player.method_7353((class_2561)class_2561.method_43471((String)"chat.powah.wrench.link.start").method_27692(class_124.field_1054), true);
                });
                return true;
            }
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderHud(class_332 gui, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 result, @Nullable class_2586 te) {
        EnergizingOrbTile orb;
        if (te instanceof EnergizingOrbTile && (orb = (EnergizingOrbTile)te).getBuffer().getCapacity() > 0L) {
            RenderSystem.getModelViewStack().pushMatrix();
            RenderSystem.enableBlend();
            class_310 mc = class_310.method_1551();
            class_327 font = mc.field_1772;
            int x = mc.method_22683().method_4486() / 2;
            int y = mc.method_22683().method_4502();
            String s = String.valueOf(class_124.field_1060) + orb.getBuffer().getPercent() + "%";
            String s1 = String.valueOf(class_124.field_1080) + class_1074.method_4662((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(orb.getBuffer().getEnergyStored()), Util.numFormat(orb.getBuffer().getCapacity())});
            gui.method_25303(font, s, Math.round((float)x - (float)font.method_1727(s) / 2.0f), y - 90, 0xFFFFFF);
            gui.method_25303(font, s1, Math.round((float)x - (float)font.method_1727(s1) / 2.0f), y - 75, 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.getModelViewStack().popMatrix();
        }
        return true;
    }
}

