/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.lib.block.AbstractTickableTile;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.inventory.RecipeWrapper;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.recipe.Recipes;

public class EnergizingOrbTile
extends AbstractTickableTile<IVariant.Single, EnergizingOrbBlock>
implements IInventoryHolder {
    private final Energy buffer = Energy.create(0L);
    private boolean containRecipe;
    @Nullable
    private EnergizingRecipe recipe;

    public EnergizingOrbTile(class_2338 pos, class_2680 state) {
        super(Tiles.ENERGIZING_ORB.get(), pos, state);
        this.inv.set(7);
    }

    @Override
    public void readSync(class_7225.class_7874 registries, class_2487 nbt) {
        super.readSync(registries, nbt);
        this.buffer.read(nbt, "buffer", true, false);
        this.buffer.setTransfer(this.buffer.getCapacity());
        this.containRecipe = nbt.method_10577("contain_recipe");
    }

    @Override
    public class_2487 writeSync(class_7225.class_7874 registries, class_2487 nbt) {
        this.buffer.write(nbt, "buffer", true, false);
        nbt.method_10556("contain_recipe", this.containRecipe);
        return super.writeSync(registries, nbt);
    }

    public class_2350 getOrbUp() {
        class_2680 state;
        if (this.field_11863 != null && (state = this.method_11010()).method_28498((class_2769)class_2741.field_12525)) {
            return ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153();
        }
        return class_2350.field_11036;
    }

    public class_243 getOrbCenter() {
        class_2350 up = this.getOrbUp();
        double scale = 0.1;
        return class_243.method_24953((class_2382)this.field_11867).method_1031((double)up.method_10148() * scale, (double)up.method_10164() * scale, (double)up.method_10165() * scale);
    }

    @Nullable
    public EnergizingRecipe currRecipe() {
        return this.recipe;
    }

    @Override
    protected void onFirstTick(class_1937 world) {
        super.onFirstTick(world);
        this.checkRecipe();
    }

    @Override
    public void onSlotChanged(int index) {
        if (!this.isRemote()) {
            this.buffer.setCapacity(0L);
            this.buffer.setStored(0L);
            this.buffer.setTransfer(0L);
            this.checkRecipe();
        }
    }

    private void checkRecipe() {
        if (this.field_11863 != null && !this.isRemote()) {
            Optional recipe = this.field_11863.method_8433().method_8132(Recipes.ENERGIZING.get(), (class_9695)new RecipeWrapper(this.getInventory()), this.field_11863);
            if (recipe.isPresent()) {
                this.recipe = (EnergizingRecipe)((class_8786)recipe.get()).comp_1933();
                this.buffer.setCapacity(this.recipe.getEnergy());
                this.buffer.setTransfer(this.recipe.getEnergy());
            } else {
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
            }
            this.setContainRecipe(recipe.isPresent());
            this.sync(1);
        }
    }

    public long fillEnergy(long amount) {
        long filled = Math.min(this.buffer.getEmpty(), amount);
        if (this.field_11863 != null && this.recipe != null) {
            this.buffer.produce(filled);
            if (this.buffer.isFull()) {
                class_1799 stack = this.recipe.method_8110((class_7225.class_7874)this.field_11863.method_30349());
                this.inv.clear();
                this.inv.setStackInSlot(0, stack.method_7972());
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
                this.method_5431();
            }
            this.sync(5);
        }
        return filled;
    }

    public boolean containRecipe() {
        return this.containRecipe;
    }

    public void setContainRecipe(boolean containRecipe) {
        this.containRecipe = containRecipe;
    }

    public Energy getBuffer() {
        return this.buffer;
    }

    @Override
    public int getSlotLimit(int index) {
        return index == 0 ? 64 : 1;
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return slot == 0;
    }

    @Override
    public boolean canInsert(int index, class_1799 stack) {
        return index != 0 && this.inv.getStackInSlot(0).method_7960() && this.inv.getStackInSlot(index).method_7960();
    }
}

