/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import owmii.powah.Powah;
import owmii.powah.lib.logistics.inventory.RecipeWrapper;
import owmii.powah.recipe.Recipes;

public class EnergizingRecipe
implements class_1860<RecipeWrapper> {
    public static final class_2960 ID = Powah.id("energizing");
    private final class_1799 output;
    private final long energy;
    private final class_2371<class_1856> ingredients;

    public EnergizingRecipe(class_1799 output, long energy, class_1856 ... ingredients) {
        this(output, energy, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
    }

    public EnergizingRecipe(class_1799 output, long energy, class_2371<class_1856> ingredients) {
        this.output = output;
        this.energy = energy;
        this.ingredients = ingredients;
    }

    public boolean matches(RecipeWrapper inv, class_1937 world) {
        ArrayList<class_1856> stacks = new ArrayList<class_1856>((Collection<class_1856>)this.method_8117());
        for (int i = 1; i < inv.method_59983(); ++i) {
            class_1799 stack = inv.method_59984(i);
            if (stack.method_7960()) continue;
            boolean flag = false;
            Iterator itr = stacks.iterator();
            while (itr.hasNext()) {
                class_1856 ingredient = (class_1856)itr.next();
                if (!ingredient.method_8093(stack)) continue;
                flag = true;
                itr.remove();
                break;
            }
            if (flag) continue;
            return false;
        }
        return stacks.isEmpty();
    }

    public class_1799 assemble(RecipeWrapper inv, class_7225.class_7874 lookup) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 getResultItem() {
        return this.output;
    }

    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return Recipes.ENERGIZING_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return Recipes.ENERGIZING.get();
    }

    public long getEnergy() {
        return this.energy;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<EnergizingRecipe> {
        public static final MapCodec<EnergizingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_51397.fieldOf("result").forGetter(EnergizingRecipe::getResultItem), (App)Codec.LONG.optionalFieldOf("energy", (Object)0L).flatXmap(energy -> {
            if (energy <= 0L) {
                return DataResult.error(() -> "Energizing recipe require energy to work!!");
            }
            return DataResult.success((Object)Math.max(1L, (long)((double)energy.longValue() * Powah.config().general.energizing_energy_ratio)));
        }, DataResult::success).forGetter(EnergizingRecipe::getEnergy), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] ingredientsArray = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (ingredientsArray.length == 0) {
                throw new JsonParseException("No ingredients for energizing recipe");
            }
            if (ingredientsArray.length > 6) {
                throw new JsonParseException("Too many ingredients for energizing recipe the max is 6");
            }
            if (ingredientsArray.length == 0) {
                return DataResult.error(() -> "No ingredients for energizing recipe");
            }
            return ingredientsArray.length > 6 ? DataResult.error(() -> "Too many ingredients for energizing recipe the max is 6") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredientsArray));
        }, DataResult::success).forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, EnergizingRecipe::new));
        public static final class_9139<class_9129, EnergizingRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public static EnergizingRecipe fromNetwork(class_9129 buffer) {
            class_2371 list = class_2371.method_10213((int)buffer.readInt(), (Object)class_1856.field_9017);
            list.replaceAll(ingredient -> (class_1856)class_1856.field_48355.decode((Object)buffer));
            class_1799 output = (class_1799)class_1799.field_48349.decode((Object)buffer);
            return new EnergizingRecipe(output, buffer.readLong(), (class_2371<class_1856>)list);
        }

        public static void toNetwork(class_9129 buffer, EnergizingRecipe recipe) {
            buffer.method_53002(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> class_1856.field_48355.encode((Object)buffer, ingredient));
            class_1799.field_48349.encode((Object)buffer, (Object)recipe.output);
            buffer.method_52974(recipe.energy);
        }

        public MapCodec<EnergizingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, EnergizingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

