/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodBlock;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.util.NBT;
import owmii.powah.lib.util.Ticker;

public class EnergizingRodTile
extends AbstractEnergyStorage<EnergyConfig, EnergizingRodBlock> {
    private class_2338 orbPos = class_2338.field_10980;
    public final Ticker coolDown = new Ticker(20.0);

    public EnergizingRodTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.ENERGIZING_ROD.get(), pos, state, variant);
    }

    public EnergizingRodTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(class_7225.class_7874 registries, class_2487 nbt) {
        super.readSync(registries, nbt);
        this.orbPos = NBT.readPos(nbt, "OrbPos");
    }

    @Override
    public class_2487 writeSync(class_7225.class_7874 registries, class_2487 nbt) {
        NBT.writePos(nbt, this.orbPos, "OrbPos");
        return super.writeSync(registries, nbt);
    }

    @Override
    protected int postTick(class_1937 world) {
        boolean flag = false;
        EnergizingOrbTile orb = this.getOrbTile();
        if (orb != null) {
            if (orb.containRecipe() && this.energy.hasEnergy()) {
                this.coolDown.onward();
                flag = true;
            } else if (this.coolDown.getTicks() > 0.0) {
                this.coolDown.back();
                flag = true;
            }
            if (this.coolDown.ended()) {
                long fill = Math.min(this.energy.getEnergyStored(), ((EnergizingRodBlock)this.getBlock()).getConfig().getTransfer((Tier)this.getVariant()));
                this.energy.consume(orb.fillEnergy(fill));
                flag = true;
            }
        }
        return flag ? 10 : -1;
    }

    @Nullable
    public EnergizingOrbTile getOrbTile() {
        class_2586 tile;
        if (this.field_11863 != null && this.orbPos != class_2338.field_10980 && this.field_11863.method_8477(this.orbPos) && (tile = this.field_11863.method_8321(this.orbPos)) instanceof EnergizingOrbTile) {
            return (EnergizingOrbTile)tile;
        }
        return null;
    }

    public boolean hasOrb() {
        return this.getOrbTile() != null;
    }

    public class_2338 getOrbPos() {
        return this.orbPos;
    }

    public void setOrbPos(class_2338 orbPos) {
        this.orbPos = orbPos;
        this.sync(2);
    }

    public class_238 getRenderBoundingBox() {
        int range = Powah.config().general.energizing_range;
        return new class_238(this.method_11016()).method_1014((double)range);
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean isEnergyPresent(@Nullable class_2350 side) {
        return side != null && side.equals((Object)this.method_11010().method_11654((class_2769)class_2741.field_12525));
    }
}

