/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.magmator;

import dev.architectury.fluid.FluidStack;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.magmator.MagmatorBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.util.Util;

public class MagmatorTile
extends AbstractEnergyProvider<MagmatorBlock>
implements IInventoryHolder,
ITankHolder {
    protected final Energy buffer = Energy.create(0L);
    protected boolean burning;

    public MagmatorTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.MAGMATOR.get(), pos, state, variant);
        this.tank.setCapacity(FluidStack.bucketAmount() * 4L).validate(stack -> PowahAPI.getMagmaticFluidHeat(stack.getFluid()) != 0).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public MagmatorTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(class_7225.class_7874 registries, class_2487 nbt) {
        super.readSync(registries, nbt);
        this.energy.read(nbt, "energy_buffer", true, false);
        this.burning = nbt.method_10577("burning");
    }

    @Override
    public class_2487 writeSync(class_7225.class_7874 registries, class_2487 nbt) {
        this.energy.write(nbt, "energy_buffer", true, false);
        nbt.method_10556("burning", this.burning);
        return super.writeSync(registries, nbt);
    }

    @Override
    protected int postTick(class_1937 world) {
        if (!this.isRemote() && this.checkRedstone()) {
            long min;
            FluidStack fluid;
            int fluidHeat;
            boolean flag = false;
            if (this.buffer.isEmpty() && !this.tank.isEmpty() && (fluidHeat = PowahAPI.getMagmaticFluidHeat((fluid = this.tank.getFluid()).getFluid())) > 0) {
                long amountPerDrain = 100L * (long)Util.millibucketAmount();
                long minStored = Math.min(this.tank.getFluidAmount(), amountPerDrain);
                this.buffer.setStored(minStored * (long)fluidHeat / amountPerDrain);
                this.buffer.setCapacity(minStored * (long)fluidHeat / amountPerDrain);
                this.tank.drain(minStored, false);
            }
            if ((min = Math.min(this.getGeneration(), this.buffer.getStored())) > 0L && this.energy.getEmpty() >= min) {
                this.energy.produce(min);
                this.buffer.consume(min);
                flag = true;
                this.sync(4);
            }
            if (this.burning != flag) {
                this.burning = flag;
                this.sync(4);
            }
        }
        return this.chargeItems(1) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public Tank getTank() {
        return this.tank;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean keepFluid() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }

    public boolean isBurning() {
        return this.burning;
    }
}

