/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.fuel.FuelRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.reactor.Builder;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.item.Itms;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.util.Ticker;

public class ReactorTile
extends AbstractEnergyProvider<ReactorBlock>
implements IInventoryHolder,
ITankHolder {
    private final Builder builder = new Builder(this);
    public final Ticker fuel = new Ticker(1000.0);
    public final Ticker carbon = Ticker.empty();
    public final Ticker redstone = Ticker.empty();
    public final Ticker solidCoolant = Ticker.empty();
    public int solidCoolantTemp;
    public final Ticker temp = new Ticker(1000.0);
    private int redstoneTemp;
    private int carbonTemp;
    private int baseTemp;
    public final Ticker bright = new Ticker(20.0);
    private boolean running;
    private boolean genModeOn;
    private boolean generate = true;

    public ReactorTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.REACTOR.get(), pos, state, variant);
        this.tank.setCapacity(FluidStack.bucketAmount()).validate(stack -> PowahAPI.getCoolant(stack.getFluid()) != 0).setChange(() -> this.sync(10));
        this.inv.add(5);
    }

    public ReactorTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void loadServerOnly(class_2487 nbt) {
        super.loadServerOnly(nbt);
        this.baseTemp = nbt.method_10550("base_temp");
        this.carbonTemp = nbt.method_10550("carbon_temp");
        this.redstoneTemp = nbt.method_10550("redstone_temp");
    }

    @Override
    public class_2487 saveServerOnly(class_2487 nbt) {
        nbt.method_10569("base_temp", this.baseTemp);
        nbt.method_10569("carbon_temp", this.carbonTemp);
        nbt.method_10569("redstone_temp", this.redstoneTemp);
        return super.saveServerOnly(nbt);
    }

    @Override
    public void readSync(class_7225.class_7874 registries, class_2487 nbt) {
        super.readSync(registries, nbt);
        this.builder.read(nbt);
        this.fuel.read(nbt, "fuel");
        this.carbon.read(nbt, "carbon");
        this.redstone.read(nbt, "redstone");
        this.solidCoolant.read(nbt, "solid_coolant");
        this.solidCoolantTemp = nbt.method_10550("solid_coolant_temp");
        this.running = nbt.method_10577("running");
        this.genModeOn = nbt.method_10577("gen_mode");
        this.generate = nbt.method_10577("generate");
        this.temp.read(nbt, "temperature");
    }

    @Override
    public class_2487 writeSync(class_7225.class_7874 registries, class_2487 nbt) {
        this.builder.write(nbt);
        this.fuel.write(nbt, "fuel");
        this.carbon.write(nbt, "carbon");
        this.redstone.write(nbt, "redstone");
        this.solidCoolant.write(nbt, "solid_coolant");
        nbt.method_10569("solid_coolant_temp", this.solidCoolantTemp);
        nbt.method_10556("running", this.running);
        nbt.method_10556("gen_mode", this.genModeOn);
        nbt.method_10556("generate", this.generate);
        this.temp.write(nbt, "temperature");
        return super.writeSync(registries, nbt);
    }

    @Override
    protected int postTick(class_1937 world) {
        if (this.isRemote() || !this.builder.isDone(world)) {
            return -1;
        }
        long extracted = this.chargeItems(1);
        boolean flag = false;
        boolean flag2 = false;
        if (this.checkRedstone() && this.generate) {
            boolean generating = !this.energy.isFull() && !this.fuel.isEmpty();
            boolean b0 = this.processFuel(world);
            boolean b1 = this.processCarbon(world, generating);
            boolean b2 = this.processRedstone(world, generating);
            boolean b3 = this.processTemperature(world, generating);
            if (b0 || b1 || b2 || b3) {
                flag = true;
            }
            if (generating) {
                this.fuel.back(this.calcConsumption());
                this.energy.produce((long)this.calcProduction());
                flag = true;
                flag2 = true;
            }
            if (flag && this.isContainerOpen) {
                this.sync(3);
            }
        }
        this.checkGenMode();
        for (class_2350 direction : class_2350.values()) {
            if (!this.canExtractEnergy(direction)) continue;
            long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
            class_2338 pos = this.field_11867.method_10079(direction, direction.method_10166().method_10179() ? 2 : (direction.equals((Object)class_2350.field_11036) ? 4 : 1));
            long received = EnvHandler.INSTANCE.pushEnergy(world, pos, direction.method_10153(), amount);
            extracted += this.extractEnergy((int)received, false, direction);
        }
        if (this.running != flag2) {
            this.running = flag2;
            this.sync(5);
        }
        return extracted > 0L ? 5 : -1;
    }

    @Override
    protected void clientTick(class_1937 world) {
        if (this.running) {
            this.bright.onward();
        } else {
            this.bright.back();
        }
    }

    private void checkGenMode() {
        if (this.genModeOn) {
            if (this.energy.isFull()) {
                this.generate = false;
            } else if (this.energy.getPercent() <= 70L) {
                this.generate = true;
            }
        }
    }

    public double calcProduction() {
        double d = this.carbon.isEmpty() ? 1.2 : 1.0;
        double d1 = this.redstone.isEmpty() ? 1.4 : 1.0;
        return (1.0 - this.calc()) * (this.fuel.getTicks() / 1000.0) * (double)this.getGeneration() / d / d1;
    }

    public double calcConsumption() {
        if (this.running) {
            double d1 = 1.0 + (double)((Tier)this.variant).ordinal() * 0.25;
            return (1.0 + (double)((Tier)this.variant).ordinal() * 0.25) * this.calc();
        }
        return 0.0;
    }

    public double calc() {
        double d0 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return this.temp.getTicks() / 1000.0 * 0.98 / 2.0 * d0;
    }

    private boolean processTemperature(class_1937 world, boolean generating) {
        class_1799 stack;
        boolean flag = false;
        if (this.solidCoolant.isEmpty() && !(stack = this.inv.getStackInSlot(4)).method_7960()) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((class_1935)stack.method_7909());
            int size = (Integer)coolant.getLeft();
            int temp = (Integer)coolant.getRight();
            if (size > 0 && temp < 2) {
                this.solidCoolant.setAll(size);
                this.solidCoolantTemp = temp;
                stack.method_7934(1);
                flag = true;
            }
        }
        if (!this.solidCoolant.isEmpty()) {
            if (!this.tank.isEmpty() && generating && this.ticks % 40 == 0) {
                this.solidCoolant.back();
                if (this.solidCoolant.isEmpty()) {
                    this.solidCoolant.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.solidCoolantTemp = 0;
        }
        double temp = Math.min((double)(this.baseTemp + this.carbonTemp + this.redstoneTemp), this.temp.getMax());
        if (!this.tank.isEmpty()) {
            int coldness = -PowahAPI.getCoolant(this.tank.getFluid().getFluid());
            int i = Math.abs(coldness + this.solidCoolantTemp) + 1;
            temp /= (double)i;
            this.sync(5);
        }
        if (this.temp.getTicks() < temp) {
            this.temp.onward();
            flag = true;
        }
        if (this.ticks % (this.tank.isEmpty() ? 5 : (this.solidCoolant.isEmpty() ? 3 : 1)) == 0 && this.temp.getTicks() > temp) {
            this.temp.back();
            flag = true;
        }
        return flag;
    }

    private boolean processRedstone(class_1937 world, boolean generating) {
        boolean flag = false;
        if (this.redstone.isEmpty()) {
            class_1799 stack = this.inv.getStackInSlot(3);
            if (stack.method_7909() == class_1802.field_8725) {
                this.redstone.setAll(18.0);
            } else if (stack.method_7909() == class_1802.field_8793) {
                this.redstone.setAll(162.0);
            }
            this.redstoneTemp = 120;
            stack.method_7934(1);
            flag = true;
        }
        if (!this.redstone.isEmpty()) {
            if (generating && this.ticks % 40 == 0) {
                this.redstone.back();
                if (this.redstone.isEmpty()) {
                    this.redstone.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.redstoneTemp = 0;
        }
        return flag;
    }

    private boolean processCarbon(class_1937 world, boolean generating) {
        int carbon;
        class_1799 stack;
        boolean flag = false;
        if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(2)).method_7960() && (carbon = FuelRegistry.get((class_1799)stack)) > 0) {
            this.carbon.setAll(carbon);
            this.carbonTemp = 180;
            stack.method_7934(1);
            flag = true;
        }
        if (!this.carbon.isEmpty()) {
            if (generating) {
                this.carbon.back();
                if (this.carbon.isEmpty()) {
                    this.carbon.setMax(0.0);
                }
            }
        } else {
            this.carbonTemp = 0;
        }
        return flag;
    }

    private boolean processFuel(class_1937 world) {
        class_1799 stack;
        boolean flag = false;
        if (this.fuel.getTicks() <= 900.0 && (stack = this.inv.getStackInSlot(1)).method_7909() == Itms.URANINITE.get()) {
            this.fuel.add(100.0);
            this.baseTemp = 700;
            stack.method_7934(1);
            flag = true;
        }
        if (this.fuel.isEmpty()) {
            this.baseTemp = 0;
        }
        return flag;
    }

    @Override
    public void onPlaced(class_1937 world, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.onPlaced(world, state, placer, stack);
        this.builder.shuffle();
    }

    public void demolish(class_1937 world) {
        this.builder.demolish(world);
        while (this.fuel.getTicks() >= 100.0) {
            class_2248.method_9577((class_1937)world, (class_2338)this.field_11867, (class_1799)new class_1799((class_1935)Itms.URANINITE.get()));
            this.fuel.back(100.0);
        }
    }

    public boolean isBuilt() {
        return this.builder.built;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        if (slot == 1) {
            return stack.method_7909() == Itms.URANINITE.get();
        }
        if (slot == 2) {
            return FuelRegistry.get((class_1799)stack) > 0 && stack.getRecipeRemainder().method_7960();
        }
        if (slot == 3) {
            return stack.method_7909() == class_1802.field_8725 || stack.method_7909() == class_1802.field_8793;
        }
        if (slot == 4) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((class_1935)stack.method_7909());
            return (Integer)coolant.getLeft() > 0 && (Integer)coolant.getRight() < 2;
        }
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }

    @Override
    public Tank getTank() {
        return this.tank;
    }

    @Override
    public boolean keepFluid() {
        return false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isGenModeOn() {
        return this.genModeOn;
    }

    public void setGenModeOn(boolean genModeOn) {
        this.genModeOn = genModeOn;
        this.sync();
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867).method_1009(1.0, 3.0, 1.0);
    }
}

