/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.solar.SolarBlock;
import owmii.powah.item.Itms;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Misc;

public class SolarTile
extends AbstractEnergyProvider<SolarBlock>
implements IInventoryHolder {
    public static final String CAN_SEE_SKY = "can_see_sky";
    public static final String HAS_LENS_OF_ENDER = "has_lens_of_ender";
    private boolean canSeeSky;
    private boolean hasLensOfEnder;

    public SolarTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.SOLAR_PANEL.get(), pos, state, variant);
        this.inv.add(1);
    }

    public SolarTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(class_7225.class_7874 registries, class_2487 compound) {
        super.readSync(registries, compound);
        this.canSeeSky = compound.method_10577(CAN_SEE_SKY);
        this.hasLensOfEnder = compound.method_10577(HAS_LENS_OF_ENDER);
    }

    @Override
    public class_2487 writeSync(class_7225.class_7874 registries, class_2487 compound) {
        compound.method_10556(CAN_SEE_SKY, this.canSeeSky);
        compound.method_10556(HAS_LENS_OF_ENDER, this.hasLensOfEnder);
        return super.writeSync(registries, compound);
    }

    @Override
    protected int postTick(class_1937 world) {
        boolean flag;
        if (this.isRemote()) {
            return -1;
        }
        boolean bl = flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        if (this.checkRedstone()) {
            boolean canSeeSkyNow;
            if (!this.hasLensOfEnder && (long)this.ticks % 40L == 0L && this.canSeeSky != (canSeeSkyNow = Misc.canBlockSeeSky(world, this.field_11867.method_10084()))) {
                this.canSeeSky = canSeeSkyNow;
                this.sync();
            }
            if (!this.energy.isFull() && (this.canSeeSky || this.hasLensOfEnder) && world.method_8597().comp_642() && world.method_8594() < 4) {
                this.energy.produce(this.getGeneration());
                flag = true;
            }
        }
        return flag ? 5 : -1;
    }

    @Override
    public void onRemoved(class_1937 world, class_2680 state, class_2680 newState, boolean isMoving) {
        super.onRemoved(world, state, newState, isMoving);
        if (state.method_26204() != newState.method_26204() && this.hasLensOfEnder) {
            class_2248.method_9577((class_1937)world, (class_2338)this.field_11867, (class_1799)new class_1799((class_1935)Itms.LENS_OF_ENDER.get()));
        }
    }

    public boolean canSeeSky() {
        return this.canSeeSky;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean isEnergyPresent(@Nullable class_2350 side) {
        return class_2350.field_11033.equals((Object)side);
    }

    public boolean hasLensOfEnder() {
        return this.hasLensOfEnder;
    }

    public void setHasLensOfEnder(boolean hasLensOfEnder) {
        this.hasLensOfEnder = hasLensOfEnder;
        this.sync();
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }
}

