/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.block.Tier;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTickableTile;
import owmii.powah.lib.logistics.IRedstoneInteract;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.energy.SideConfig;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Util;

public abstract class AbstractEnergyStorage<C extends IEnergyConfig<Tier>, B extends AbstractEnergyBlock<C, B>>
extends AbstractTickableTile<Tier, B>
implements IRedstoneInteract {
    protected final SideConfig sideConfig = new SideConfig(this);
    protected final Energy energy = Energy.create(0L);

    public AbstractEnergyStorage(class_2591<?> type, class_2338 pos, class_2680 state) {
        this(type, pos, state, (Tier)IVariant.getEmpty());
    }

    public AbstractEnergyStorage(class_2591<?> type, class_2338 pos, class_2680 state, Tier variant) {
        super(type, pos, state, variant);
    }

    @Override
    public void readSync(class_7225.class_7874 registries, class_2487 nbt) {
        this.sideConfig.read(nbt);
        if (!this.keepEnergy()) {
            this.energy.read(nbt, true, false);
        }
        super.readSync(registries, nbt);
    }

    @Override
    public class_2487 writeSync(class_7225.class_7874 registries, class_2487 nbt) {
        this.sideConfig.write(nbt);
        if (!this.keepEnergy()) {
            this.energy.write(nbt, true, false);
        }
        return super.writeSync(registries, nbt);
    }

    @Override
    public void readStorable(class_7225.class_7874 registries, class_2487 nbt) {
        if (this.keepEnergy()) {
            this.energy.read(nbt, false, false);
        }
        super.readStorable(registries, nbt);
    }

    @Override
    public class_2487 writeStorable(class_7225.class_7874 registries, class_2487 nbt) {
        if (this.keepEnergy()) {
            this.energy.write(nbt, false, false);
        }
        return super.writeStorable(registries, nbt);
    }

    public boolean keepEnergy() {
        return false;
    }

    @Override
    protected void onFirstTick(class_1937 world) {
        super.onFirstTick(world);
        this.energy.setCapacity(this.getEnergyCapacity());
        this.energy.setTransfer(this.getEnergyTransfer());
        this.getSideConfig().init();
        this.sync();
    }

    protected long extractFromSides(class_1937 world) {
        long extracted = 0L;
        if (!this.isRemote()) {
            for (class_2350 side : class_2350.values()) {
                if (!this.canExtractEnergy(side)) continue;
                long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
                long toExtract = EnvHandler.INSTANCE.pushEnergy(world, this.field_11867.method_10093(side), side.method_10153(), amount);
                extracted += this.extractEnergy(Util.safeInt(toExtract), false, side);
            }
        }
        return extracted;
    }

    protected long chargeItems(int i) {
        return this.chargeItems(0, i);
    }

    protected long chargeItems(int i, int j) {
        Energy energy = this.getEnergy();
        long charged = EnvHandler.INSTANCE.chargeItemsInInventory(this.inv, i, j, this.getEnergyTransfer(), energy.getStored());
        energy.consume(charged);
        return charged;
    }

    public long extractEnergy(long maxExtract, boolean simulate, @Nullable class_2350 side) {
        if (!this.canExtractEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long extracted = Math.min(energy.getStored(), Math.min(energy.getMaxExtract(), maxExtract));
        if (!simulate && extracted > 0L) {
            energy.consume(extracted);
            this.sync(10);
        }
        return extracted;
    }

    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable class_2350 side) {
        if (!this.canReceiveEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long received = Math.min(energy.getEmpty(), Math.min(energy.getMaxReceive(), maxReceive));
        if (!simulate && received > 0L) {
            energy.produce(received);
            this.sync(10);
        }
        return received;
    }

    public boolean canExtractEnergy(@Nullable class_2350 side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((class_2350)side).canExtract;
    }

    public boolean canReceiveEnergy(@Nullable class_2350 side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((class_2350)side).canReceive;
    }

    public boolean isEnergyPresent(@Nullable class_2350 side) {
        return true;
    }

    @Override
    public void onAdded(class_1937 world, class_2680 state, class_2680 oldState, boolean isMoving) {
        super.onAdded(world, state, oldState, isMoving);
        if (state.method_26204() != oldState.method_26204()) {
            this.getSideConfig().init();
        }
    }

    protected long getEnergyCapacity() {
        return this.getConfig().getCapacity((Tier)((Tier)this.getVariant()));
    }

    protected long getEnergyTransfer() {
        return this.getConfig().getTransfer((Tier)((Tier)this.getVariant()));
    }

    protected C getConfig() {
        return (C)((IEnergyConfig)((AbstractEnergyBlock)this.getBlock()).getConfig());
    }

    public Energy getEnergy() {
        return this.energy;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public SideConfig getSideConfig() {
        return this.sideConfig;
    }
}

