/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import owmii.powah.lib.logistics.Redstone;
import owmii.powah.lib.logistics.Transfer;

public class Texture {
    private static final Builder BUILDER = new Builder("lollipop");
    public static final Texture EMPTY = BUILDER.make("empty", 0, 0, 0, 0);
    public static final Texture WIKI_BG_0 = BUILDER.make("wiki/bg_0", 256, 230, 0, 0);
    public static final Texture WIKI_BG_1 = BUILDER.make("wiki/bg_1", 126, 230, 0, 0);
    public static final Texture WIKI_TAB_ON = BUILDER.make("wiki/bg_1", 31, 26, 168, 0);
    public static final Texture WIKI_TAB_OFF = BUILDER.make("wiki/bg_1", 26, 26, 168, 26);
    public static final Map<Boolean, Texture> WIKI_TABS = new HashMap<Boolean, Texture>();
    public static final Texture WIKI_FRM = BUILDER.make("wiki/bg_1", 24, 24, 126, 42);
    public static final Texture WIKI_BIG_FRM = BUILDER.make("wiki/bg_1", 42, 42, 126, 0);
    public static final Texture WIKI_RCP_FRM = BUILDER.make("wiki/bg_1", 32, 32, 199, 0);
    public static final Texture WIKI_NEXT = BUILDER.make("wiki/bg_1", 15, 10, 150, 42);
    public static final Texture WIKI_PREV = BUILDER.make("wiki/bg_1", 15, 10, 150, 52);
    public static final Texture WIKI_ITM_NEXT = BUILDER.make("wiki/bg_1", 10, 18, 136, 66);
    public static final Texture WIKI_ITM_PREV = BUILDER.make("wiki/bg_1", 10, 18, 126, 66);
    public static final Texture WIKI_INF_LN_BG = BUILDER.make("wiki/bg_1", 143, 19, 0, 230);
    public static final Texture WIKI_TWITTER = BUILDER.make("wiki/social/twitter", 12, 12);
    public static final Texture WIKI_PATREON = BUILDER.make("wiki/social/patreon", 12, 12);
    public static final Texture SLOT_HIGHLIGHT_BG = BUILDER.make("container/misc", 16, 16, 0, 0);
    public static final Map<Transfer, Texture> CONFIG = new HashMap<Transfer, Texture>();
    public static final Texture CONFIG_BTN_BG = BUILDER.make("container/button_ov", 23, 25, 0, 0);
    public static final Texture CONFIG_BTN = BUILDER.make("container/button_ov", 5, 5, 23, 16);
    public static final Texture CONFIG_BTN_ALL = BUILDER.make("container/button_ov", 5, 5, 28, 16);
    public static final Texture CONFIG_BTN_OUT = BUILDER.make("container/button_ov", 5, 5, 33, 16);
    public static final Texture CONFIG_BTN_IN = BUILDER.make("container/button_ov", 5, 5, 38, 16);
    public static final Texture CONFIG_BTN_OFF = BUILDER.make("container/button_ov", 5, 5, 43, 16);
    public static final Map<Redstone, Texture> REDSTONE = new HashMap<Redstone, Texture>();
    public static final Texture REDSTONE_BTN_BG = BUILDER.make("container/button_ov", 15, 16, 23, 0);
    public static final Texture REDSTONE_BTN_IGNORE = BUILDER.make("container/button_ov", 9, 8, 38, 0);
    public static final Texture REDSTONE_BTN_OFF = BUILDER.make("container/button_ov", 9, 8, 47, 0);
    public static final Texture REDSTONE_BTN_ON = BUILDER.make("container/button_ov", 9, 8, 38, 8);
    private final class_2960 location;
    private final int width;
    private final int height;
    private final int u;
    private final int v;
    private final int tw;
    private final int th;

    public Texture(class_2960 location, int width, int height) {
        this(location, width, height, 0, 0, width, height);
    }

    public Texture(class_2960 location, int width, int height, int u, int v) {
        this(location, width, height, u, v, 256, 256);
    }

    public Texture(class_2960 location, int width, int height, int u, int v, int dim) {
        this(location, width, height, u, v, dim, dim);
    }

    public Texture(class_2960 location, int width, int height, int u, int v, int tw, int th) {
        this.location = location;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.tw = tw;
        this.th = th;
    }

    public void drawScalableW(class_332 gui, float size, int x, int y) {
        this.scaleW((int)(size * (float)this.width)).draw(gui, x, y);
    }

    public void drawScalableH(class_332 gui, float size, int x, int y) {
        int i = (int)(size * (float)this.height);
        this.scaleH(i).moveV(this.height - i).draw(gui, x, y + this.height - i);
    }

    public void draw(class_332 gui, int x, int y) {
        if (!this.isEmpty()) {
            gui.method_25290(this.getLocation(), x, y, (float)this.getU(), (float)this.getV(), this.getWidth(), this.getHeight(), this.tw, this.th);
        }
    }

    public void bindTexture(class_2960 guiTexture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)guiTexture);
    }

    public Texture addW(int width) {
        return this.scaleW(this.width + width);
    }

    public Texture addH(int height) {
        return this.scaleH(this.height + height);
    }

    public Texture remW(int width) {
        return this.scaleW(this.width - width);
    }

    public Texture remH(int height) {
        return this.scaleH(this.height - height);
    }

    public Texture scaleW(int width) {
        return this.scale(width, this.height);
    }

    public Texture scaleH(int height) {
        return this.scale(this.width, height);
    }

    public Texture scale(int width, int height) {
        return new Texture(this.location, width, height, this.u, this.v);
    }

    public Texture moveU(int u) {
        return this.move(u, 0);
    }

    public Texture moveV(int v) {
        return this.move(0, v);
    }

    public Texture move(int u, int v) {
        return new Texture(this.location, this.width, this.height, this.u + u, this.v + v);
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getU(int i) {
        return this.u + i;
    }

    public int getV(int i) {
        return this.v + i;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isMouseOver(int x, int y, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + this.width) && mouseY < (double)(y + this.height);
    }

    static {
        CONFIG.put(Transfer.ALL, CONFIG_BTN_ALL);
        CONFIG.put(Transfer.EXTRACT, CONFIG_BTN_OUT);
        CONFIG.put(Transfer.RECEIVE, CONFIG_BTN_IN);
        CONFIG.put(Transfer.NONE, CONFIG_BTN_OFF);
        REDSTONE.put(Redstone.IGNORE, REDSTONE_BTN_IGNORE);
        REDSTONE.put(Redstone.ON, REDSTONE_BTN_ON);
        REDSTONE.put(Redstone.OFF, REDSTONE_BTN_OFF);
        WIKI_TABS.put(true, WIKI_TAB_ON);
        WIKI_TABS.put(false, WIKI_TAB_OFF);
    }

    public static class Builder {
        private final String id;

        public Builder(String id) {
            this.id = id;
        }

        public Texture make(String path, int width, int height) {
            return new Texture(class_2960.method_60655((String)this.id, (String)("textures/gui/" + path + ".png")), width, height);
        }

        public Texture make(String path, int width, int height, int u, int v, int w, int h) {
            return new Texture(class_2960.method_60655((String)this.id, (String)("textures/gui/" + path + ".png")), width, height, u, v, w, h);
        }

        public Texture make(String path, int width, int height, int u, int v, int d) {
            return new Texture(class_2960.method_60655((String)this.id, (String)("textures/gui/" + path + ".png")), width, height, u, v, d);
        }

        public Texture make(String path, int width, int height, int u, int v) {
            return new Texture(class_2960.method_60655((String)this.id, (String)("textures/gui/" + path + ".png")), width, height, u, v);
        }
    }
}

