/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.fluid;

import dev.architectury.fluid.FluidStack;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class FluidTank {
    protected Predicate<FluidStack> validator;
    @NotNull
    protected FluidStack fluid = FluidStack.empty();
    protected long capacity;

    public FluidTank(long capacity) {
        this(capacity, e -> true);
    }

    public FluidTank(long capacity, Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public FluidTank setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public FluidTank setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    public long getCapacity() {
        return this.capacity;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluid;
    }

    public long getFluidAmount() {
        return this.fluid.getAmount();
    }

    public FluidTank readFromNBT(class_7225.class_7874 registries, class_2487 nbt) {
        if (nbt.method_10545("tank")) {
            FluidStack.read((class_7225.class_7874)registries, (class_2520)nbt.method_10562("tank")).ifPresent(this::setFluid);
        }
        return this;
    }

    public class_2487 writeToNBT(class_7225.class_7874 registries, class_2487 nbt) {
        if (!this.fluid.isEmpty()) {
            nbt.method_10566("tank", this.fluid.write(registries, (class_2520)new class_2487()));
        }
        return nbt;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public long getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public long fill(FluidStack resource, boolean simulate) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        if (simulate) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0L;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = resource.copyWithAmount(Math.min(this.capacity, resource.getAmount()));
            this.onContentsChanged();
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0L;
        }
        long filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0L) {
            this.onContentsChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.empty();
        }
        return this.drain(resource.getAmount(), simulate);
    }

    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        long drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = this.fluid.copyWithAmount(drained);
        if (!simulate && drained > 0L) {
            this.fluid.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    public void setFluid(FluidStack stack) {
        this.fluid = stack;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public long getSpace() {
        return Math.max(0L, this.capacity - this.fluid.getAmount());
    }
}

