/*
 * Decompiled with CFR 0.152.
 */
package com.falafel.NoSpreaditem;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemDespawnListener
implements Listener {
    private Set<UUID> noDespawnItems = new HashSet<UUID>();

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        if (this.noDespawnItems.contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        } else {
            this.noDespawnItems.remove(event.getEntity().getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Location deathLoc = event.getEntity().getLocation();
        ArrayList itemsToDrop = new ArrayList(event.getDrops());
        event.getDrops().clear();
        Location centeredLoc = deathLoc.clone();
        centeredLoc.setX((double)centeredLoc.getBlockX() + 0.5);
        centeredLoc.setY((double)centeredLoc.getBlockY() + 0.5);
        centeredLoc.setZ((double)centeredLoc.getBlockZ() + 0.5);
        for (ItemStack itemStack : itemsToDrop) {
            Item droppedItem = deathLoc.getWorld().dropItem(centeredLoc, itemStack);
            droppedItem.setVelocity(new Vector(0, 0, 0));
            this.noDespawnItems.add(droppedItem.getUniqueId());
        }
    }
}

