/*
 * Decompiled with CFR 0.152.
 */
package dev.voxelparrot.materialascension;

import dev.voxelparrot.materialascension.Config;
import dev.voxelparrot.materialascension.Constants;
import dev.voxelparrot.materialascension.registry.MABlocks;
import dev.voxelparrot.materialascension.registry.MAItems;
import dev.voxelparrot.materialascension.registry.MainRegistry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="materialascension")
public class MaterialAscension {
    private static final CreativeModeTab.TabVisibility DEFAULT_VISIBILITY = CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;

    public MaterialAscension() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        Constants.MA_LOG.info("You have my nyxium-handled superheated skysteel sword.");
        MAItems.init();
        MABlocks.init();
        MainRegistry.preInit();
        MainRegistry.init(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.GENERAL_SPEC, "materialascension.toml");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        for (RegistryObject<Item> reg : MainRegistry.registeredItems) {
            boolean isComponent;
            Item item = (Item)reg.get();
            String name = reg.getId().m_135815_().toLowerCase();
            boolean isWeapon = name.contains("dagger") || name.contains("spear") || name.contains("glaive") || name.contains("hammer") || name.contains("club") || name.contains("quarterstaff") || name.contains("destroyer") || name.contains("katana") || name.contains("blade") || name.contains("broadsword") || name.contains("scythe") || name.contains("sword");
            boolean bl = isComponent = name.contains("dust") || name.contains("sheet") || name.contains("plate") || name.contains("handle") || name.contains("rod") || name.contains("ingot") || name.contains("nugget");
            if (isWeapon && event.getTabKey().equals((Object)CreativeModeTabs.f_256797_)) {
                event.m_245282_((ItemLike)item, DEFAULT_VISIBILITY);
                continue;
            }
            if (!isComponent || !event.getTabKey().equals((Object)CreativeModeTabs.f_256968_)) continue;
            event.m_245282_((ItemLike)item, DEFAULT_VISIBILITY);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Constants.MA_LOG.info("Mod loading..");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        Constants.MA_LOG.info("Mod loading on server side..");
    }

    @Mod.EventBusSubscriber(modid="materialascension", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Constants.MA_LOG.info("Mod loading on client side..");
        }
    }
}

