/*
 * Decompiled with CFR 0.152.
 */
package dev.voxelparrot.materialascension;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="materialascension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.BooleanValue includeArtifacts;
    public static ForgeConfigSpec.BooleanValue includeUniqueWeapons;
    public static ForgeConfigSpec.BooleanValue includeQitqiastWeapons;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        includeArtifacts = builder.comment("Whether to include the artifact class weapons (default = true)").define("include_artifacts", true);
        includeUniqueWeapons = builder.comment("Whether to include the unique rarity weapons (default = false)").define("include_unique_weapons", false);
        includeQitqiastWeapons = builder.comment("Whether to include the special qitqiast weapons (default = true)").define("include_qitqiast_weapons", true);
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        Config.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

