/*
 * Decompiled with CFR 0.152.
 */
package dev.voxelparrot.materialascension.datagen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.voxelparrot.materialascension.Constants;
import dev.voxelparrot.materialascension.registry.MainRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class LootTableModification {
    private static final List<LootPoolSingletonContainer.Builder<?>> stone_loot_pool = Arrays.asList(LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(1).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(1).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(7).get()), 1), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(13).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(19).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(25).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(31).get()), 2));
    private static final List<LootPoolSingletonContainer.Builder<?>> iron_loot_pool = Arrays.asList(LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(2).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(8).get()), 1), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(14).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(20).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(26).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(32).get()), 2));
    private static final List<LootPoolSingletonContainer.Builder<?>> golden_loot_pool = Arrays.asList(LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(3).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(9).get()), 1), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(15).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(21).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(27).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(33).get()), 2));
    private static final List<LootPoolSingletonContainer.Builder<?>> diamond_loot_pool = Arrays.asList(LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(4).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(10).get()), 1), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(16).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(22).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(28).get()), 2), LootTableModification.createEntry(new ItemStack((ItemLike)MainRegistry.registeredItems.get(34).get()), 2));
    private static final Set<ResourceLocation> VANILLA_TABLES = Sets.newHashSet();
    private static final Map<String, ResourceLocation> BW_TABLES = Maps.newHashMap();
    public static final ResourceLocation jungle_temple = LootTableModification.registerInject("jungle_temple");
    public static final ResourceLocation igloo_chest = LootTableModification.registerInject("igloo_chest");
    public static final ResourceLocation shipwreck_supply = LootTableModification.registerInject("shipwreck_supply");
    public static final ResourceLocation simple_dungeon = LootTableModification.registerInject("simple_dungeon");
    public static final ResourceLocation abandoned_mineshaft = LootTableModification.registerInject("abandoned_mineshaft");
    public static final ResourceLocation desert_pyramid = LootTableModification.registerInject("desert_pyramid");
    public static final ResourceLocation pillager_outpost = LootTableModification.registerInject("pillager_outpost");
    public static final ResourceLocation buried_treasure = LootTableModification.registerInject("buried_treasure");
    public static final ResourceLocation shipwreck_treasure = LootTableModification.registerInject("shipwreck_treasure");
    public static final ResourceLocation stronghold_corridor = LootTableModification.registerInject("stronghold_corridor");
    public static final ResourceLocation village_weaponsmith = LootTableModification.registerInject("village/village_weaponsmith");
    public static final ResourceLocation bastion_treasure = LootTableModification.registerInject("bastion_treasure");
    public static final ResourceLocation bastion_other = LootTableModification.registerInject("bastion_other");
    public static final ResourceLocation bastion_bridge = LootTableModification.registerInject("bastion_bridge");
    public static final ResourceLocation bastion_hoglin_stable = LootTableModification.registerInject("bastion_hoglin_stable");
    public static final ResourceLocation ruined_portal = LootTableModification.registerInject("ruined_portal");
    public static final ResourceLocation end_city_treasure = LootTableModification.registerInject("end_city_treasure");
    private static int num_pools_added = 0;

    @NotNull
    static ResourceLocation registerInject(String resourceName) {
        ResourceLocation registryName = LootTableModification.register("inject/" + resourceName);
        BW_TABLES.put(resourceName, registryName);
        return registryName;
    }

    @NotNull
    static ResourceLocation register(@NotNull String resourceName) {
        return LootTableModification.register(new ResourceLocation("materialascension", resourceName));
    }

    @NotNull
    static ResourceLocation register(@NotNull ResourceLocation resourceLocation) {
        VANILLA_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    @NotNull
    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(VANILLA_TABLES);
    }

    @NotNull
    private static LootPool getInjectPool(String entryName) {
        LootPoolSingletonContainer.Builder entryBuilder = LootTableReference.m_79776_((ResourceLocation)BW_TABLES.get(entryName)).m_79707_(1);
        return LootPool.m_79043_().m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entryBuilder).m_79082_();
    }

    @SubscribeEvent
    public static void onLootLoad(@NotNull LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && BW_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                event.getTable().addPool(LootTableModification.getInjectPool(file));
                ++num_pools_added;
            }
            catch (NullPointerException e) {
                Constants.MA_LOG.warn("Failed to add to vanilla loot table: {}. This is most likely due to an incompatibility with another mod. Please report this on the Basic Weapons issue tracker, thank you.", (Object)name);
            }
        }
    }

    public static LootTableProvider getProvider(PackOutput output) {
        return new LootTableProvider(output, LootTableModification.getLootTables(), List.of(new LootTableProvider.SubProviderEntry(AddToLootTables::new, LootContextParamSets.f_81411_)));
    }

    private static LootTable.Builder newPool(List<LootPoolSingletonContainer.Builder<?>> itemBuilderList, boolean applyDamage) {
        LootPool.Builder lootPool = LootPool.m_79043_();
        LootTable.Builder lootTable = LootTable.m_79147_();
        lootPool.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f));
        for (LootPoolSingletonContainer.Builder<?> itemBuilder : itemBuilderList) {
            lootPool.m_79076_(itemBuilder);
        }
        if (applyDamage) {
            lootPool.m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.7f, (float)0.95f))).m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.5f));
        }
        lootTable.m_79161_(lootPool);
        return lootTable;
    }

    private static LootTable.Builder newEnchantedPool(List<LootPoolSingletonContainer.Builder<?>> itemBuilderList, boolean applyDamage) {
        LootPool.Builder enchantedPoolBuilder = LootPool.m_79043_();
        LootTable.Builder lootTable = LootTable.m_79147_();
        enchantedPoolBuilder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
        for (LootPoolSingletonContainer.Builder<?> itemBuilder : itemBuilderList) {
            enchantedPoolBuilder.m_79076_(itemBuilder);
        }
        enchantedPoolBuilder.m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_());
        if (applyDamage) {
            enchantedPoolBuilder.m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.7f, (float)0.95f))).m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.5f));
        }
        LootPool.Builder normalPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
        for (LootPoolSingletonContainer.Builder<?> itemBuilder : itemBuilderList) {
            normalPoolBuilder.m_79076_(itemBuilder);
        }
        lootTable.m_79161_(enchantedPoolBuilder);
        lootTable.m_79161_(normalPoolBuilder);
        return lootTable;
    }

    private static LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
        return LootItem.m_79579_((ItemLike)item.m_41720_()).m_79707_(weight);
    }

    public static class AddToLootTables
    implements LootTableSubProvider {
        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(jungle_temple, LootTableModification.newPool(stone_loot_pool, false));
            consumer.accept(igloo_chest, LootTableModification.newPool(stone_loot_pool, true));
            consumer.accept(shipwreck_supply, LootTableModification.newPool(stone_loot_pool, true));
            consumer.accept(simple_dungeon, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(abandoned_mineshaft, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(desert_pyramid, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(pillager_outpost, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(buried_treasure, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(shipwreck_treasure, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(stronghold_corridor, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(village_weaponsmith, LootTableModification.newPool(iron_loot_pool, false));
            consumer.accept(bastion_treasure, LootTableModification.newEnchantedPool(diamond_loot_pool, true));
            consumer.accept(bastion_other, LootTableModification.newEnchantedPool(golden_loot_pool, true));
            consumer.accept(bastion_bridge, LootTableModification.newPool(golden_loot_pool, false));
            consumer.accept(bastion_hoglin_stable, LootTableModification.newEnchantedPool(golden_loot_pool, true));
            consumer.accept(ruined_portal, LootTableModification.newEnchantedPool(golden_loot_pool, false));
            consumer.accept(end_city_treasure, LootTableModification.newEnchantedPool(diamond_loot_pool, false));
        }
    }
}

