/*
 * Decompiled with CFR 0.152.
 */
package dev.voxelparrot.materialascension.registry;

import dev.voxelparrot.materialascension.registry.MABlocks;
import dev.voxelparrot.materialascension.registry.MAItems;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MainRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"materialascension");
    public static final List<RegistryObject<Item>> registeredItems = new LinkedList<RegistryObject<Item>>();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"materialascension");
    public static final List<RegistryObject<Block>> registeredBlocks = new LinkedList<RegistryObject<Block>>();

    public static void preInit() {
        for (MAItems.ItemInfo item : MAItems.items) {
            RegistryObject i = ITEMS.register(item.name, item.itemSupplier);
            registeredItems.add((RegistryObject<Item>)i);
        }
        for (MABlocks.BlockInfo info : MABlocks.blocks) {
            RegistryObject blockReg = BLOCKS.register(info.name, info.blockSupplier);
            registeredBlocks.add((RegistryObject<Block>)blockReg);
            RegistryObject blockItemReg = ITEMS.register(info.name, () -> new BlockItem((Block)blockReg.get(), new Item.Properties()));
            registeredItems.add((RegistryObject<Item>)blockItemReg);
        }
    }

    public static void init(IEventBus eventBus) {
        ITEMS.register(eventBus);
        BLOCKS.register(eventBus);
    }
}

