/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.event;

import java.util.ArrayList;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoundDefinitionReplacementEvent {
    private static final ArrayList<SoundDefinitionReplacementListener> EVENT_LISTENERS = new ArrayList();

    public static void registerListener(SoundDefinitionReplacementListener listener) {
        EVENT_LISTENERS.add(listener);
    }

    public static void unregisterListener(SoundDefinitionReplacementListener listener) {
        EVENT_LISTENERS.remove(listener);
    }

    @ApiStatus.Internal
    public static Response fire(SoundType event) {
        for (SoundDefinitionReplacementListener listener : EVENT_LISTENERS) {
            Response response = listener.onSoundDefinitionReplacement(event);
            if (response.response() == ResponseType.PASS) continue;
            return response;
        }
        return Response.pass();
    }

    @FunctionalInterface
    public static interface SoundDefinitionReplacementListener {
        public Response onSoundDefinitionReplacement(@Nullable SoundType var1);
    }

    public record Response(ResponseType response, @Nullable SoundType override) {
        public static Response pass() {
            return new Response(ResponseType.PASS, null);
        }

        public static Response override(SoundType override) {
            return new Response(ResponseType.OVERRIDE, override);
        }

        public static Response cancel() {
            return new Response(ResponseType.CANCEL, null);
        }
    }

    public static enum ResponseType {
        PASS,
        OVERRIDE,
        CANCEL;

    }
}

