/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.config;

import dev.imb11.mru.LoaderUtils;
import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ChatSoundsConfig
extends ConfigGroup<ChatSoundsConfig>
implements YetAnotherConfigLib.ConfigBackedBuilder<ChatSoundsConfig> {
    @SerialEntry
    public final ConfiguredSound typingSoundEffect = new ConfiguredSound("typing", (Holder.Reference<SoundEvent>)SoundEvents.NOTE_BLOCK_HAT, true, 1.6f, 0.4f);
    @SerialEntry
    public final ConfiguredSound messageSoundEffect = new ConfiguredSound("message", (Holder.Reference<SoundEvent>)SoundEvents.NOTE_BLOCK_HAT, true, 2.0f, 0.8f);
    @SerialEntry
    public final ConfiguredSound mentionSoundEffect = new ConfiguredSound("mention", (Holder.Reference<SoundEvent>)SoundEvents.NOTE_BLOCK_CHIME, true, 1.8f, 0.9f);
    @SerialEntry
    public ArrayList<String> mentionKeywords = new ArrayList<CallSite>(List.of("@" + Minecraft.getInstance().getUser().getName()));
    @SerialEntry
    public boolean ignoreSystemChats = false;
    @SerialEntry
    public boolean enableChatSoundCooldown = false;
    @SerialEntry
    public float chatSoundCooldown = 0.5f;

    public ChatSoundsConfig() {
        super(ChatSoundsConfig.class);
    }

    @Override
    public YetAnotherConfigLib getYACL() {
        return YetAnotherConfigLib.create(this.getHandler(), (YetAnotherConfigLib.ConfigBackedBuilder)this);
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"sounds", (String)"textures/gui/chat_sounds.png");
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"sounds.config.chat");
    }

    @Override
    public String getID() {
        return "chat";
    }

    public YetAnotherConfigLib.Builder build(ChatSoundsConfig defaults, ChatSoundsConfig config, YetAnotherConfigLib.Builder builder) {
        Option chatSoundCooldownOption = SoundsConfig.HELPER.getField("chatSoundCooldown", defaults.chatSoundCooldown, () -> Float.valueOf(config.chatSoundCooldown), v -> {
            config.chatSoundCooldown = v.floatValue();
        });
        ListOption mentionKeywordsOption = ListOption.createBuilder().name((Component)Component.translatable((String)"sounds.config.mentionKeywords.option")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"sounds.config.mentionKeywords.option.description")})).binding(defaults.mentionKeywords, () -> config.mentionKeywords, value -> {
            config.mentionKeywords = new ArrayList(value);
        }).controller(StringControllerBuilder::create).initial((Object)("@" + Minecraft.getInstance().getUser().getName())).insertEntriesAtEnd(true).build();
        builder.title(Component.nullToEmpty((String)"Chat Sounds"));
        builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"sounds.config.chat.messaging")).option(SoundsConfig.HELPER.get("ignoreSystemChats", defaults.ignoreSystemChats, () -> config.ignoreSystemChats, v -> {
            config.ignoreSystemChats = v;
        })).group(config.typingSoundEffect.getOptionGroup(defaults.typingSoundEffect)).group(config.messageSoundEffect.getOptionGroup(defaults.messageSoundEffect)).group(config.mentionSoundEffect.getOptionGroup(defaults.mentionSoundEffect)).option((Option)mentionKeywordsOption).build());
        builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"sounds.config.chat.cooldown")).option(Option.createBuilder().name((Component)Component.translatable((String)"sounds.config.option.enableChatSoundCooldown")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"sounds.config.option.description.enableChatSoundCooldown")})).binding((Object)defaults.enableChatSoundCooldown, () -> config.enableChatSoundCooldown, v -> {
            config.enableChatSoundCooldown = v;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).available(!LoaderUtils.isModInstalled((String)"chatpatches")).build()).option(chatSoundCooldownOption).build());
        return builder;
    }
}

