/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin.world.mechanics;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class SwordSwingSoundEffect {
    @Shadow
    public int swingTime;
    @Unique
    public SoundInstance sounds$currentSwordSwooshSound;
    @Unique
    private static long lastPlayed = 0L;
    @Unique
    private static final long COOLDOWN = 250L;

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")})
    public void $start_sword_swoosh_sound(InteractionHand interactionHand, boolean bl, CallbackInfo ci) {
        LocalPlayer localPlayer;
        long currentTime = System.currentTimeMillis();
        LivingEntity entity = (LivingEntity)this;
        if (!entity.level().isClientSide()) {
            return;
        }
        if (entity instanceof LocalPlayer && (localPlayer = (LocalPlayer)entity).equals((Object)Minecraft.getInstance().player) && entity.getItemInHand(interactionHand).is(ItemTags.SWORDS) && currentTime - lastPlayed > 250L) {
            this.sounds$currentSwordSwooshSound = SoundsConfig.get(WorldSoundsConfig.class).swordSwooshSoundEffect.getSoundInstance();
            if (this.sounds$currentSwordSwooshSound != null) {
                SoundsConfig.get(WorldSoundsConfig.class).swordSwooshSoundEffect.playSound(this.sounds$currentSwordSwooshSound);
                lastPlayed = currentTime;
            }
        }
    }
}

