/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.gui;

import dev.imb11.sounds.config.ChatSoundsConfig;
import dev.imb11.sounds.config.EventSoundsConfig;
import dev.imb11.sounds.config.ModConfig;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.gui.GreyButton;
import dev.imb11.sounds.gui.ImageButtonWidget;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SoundsConfigScreen
extends Screen {
    private final Screen parent;
    public float timeSinceLastSupporter = -1.0f;
    public int supporterIndex = -1;

    public SoundsConfigScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"sounds.config.title"));
        this.parent = parent;
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        assert (this.minecraft != null);
        context.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"sounds.config.title"), this.width / 2, 10, 0xFFFFFF);
    }

    protected void init() {
        super.init();
        Objects.requireNonNull(this.font);
        int fontHeight = 9;
        int gridX = 10;
        int gridY = 10 + fontHeight + 10;
        int gridWidth = this.width - 15;
        int gridHeight = this.height - 20 - fontHeight - 10 - 20;
        int numColumns = 4;
        int numRows = 3;
        int cellWidth = gridWidth / numColumns;
        int cellHeight = gridHeight / numRows;
        WorldSoundsConfig worldSoundsConfig = SoundsConfig.getRaw(WorldSoundsConfig.class);
        ImageButtonWidget worldSoundsButton = new ImageButtonWidget(gridX + 0 * cellWidth, gridY + 0 * cellHeight, 2 * cellWidth - 6, 2 * cellHeight - 6, worldSoundsConfig.getName(), worldSoundsConfig.getIcon(), btn -> this.minecraft.setScreen(worldSoundsConfig.getYACL().generateScreen((Screen)this)));
        this.addRenderableWidget((GuiEventListener)worldSoundsButton);
        ChatSoundsConfig chatSoundsConfig = SoundsConfig.getRaw(ChatSoundsConfig.class);
        ImageButtonWidget chatSoundsButton = new ImageButtonWidget(gridX + 2 * cellWidth, gridY + 0 * cellHeight, 2 * cellWidth - 6, cellHeight - 6, chatSoundsConfig.getName(), chatSoundsConfig.getIcon(), btn -> this.minecraft.setScreen(chatSoundsConfig.getYACL().generateScreen((Screen)this)));
        this.addRenderableWidget((GuiEventListener)chatSoundsButton);
        EventSoundsConfig eventSoundsConfig = SoundsConfig.getRaw(EventSoundsConfig.class);
        ImageButtonWidget eventSoundsButton = new ImageButtonWidget(gridX + 2 * cellWidth, gridY + 1 * cellHeight, cellWidth - 6, cellHeight - 6, eventSoundsConfig.getName(), eventSoundsConfig.getIcon(), btn -> this.minecraft.setScreen(eventSoundsConfig.getYACL().generateScreen((Screen)this)));
        this.addRenderableWidget((GuiEventListener)eventSoundsButton);
        ModConfig modConfig = SoundsConfig.getRaw(ModConfig.class);
        ImageButtonWidget modConfigButton = new ImageButtonWidget(gridX + 3 * cellWidth, gridY + 1 * cellHeight, cellWidth - 6, 2 * cellHeight - 6, modConfig.getName(), modConfig.getIcon(), btn -> this.minecraft.setScreen(modConfig.getYACL().generateScreen((Screen)this)));
        this.addRenderableWidget((GuiEventListener)modConfigButton);
        UISoundsConfig uiSoundsConfig = SoundsConfig.getRaw(UISoundsConfig.class);
        ImageButtonWidget uiSoundsButton = new ImageButtonWidget(gridX + 0 * cellWidth, gridY + 2 * cellHeight, 3 * cellWidth - 6, cellHeight - 6, uiSoundsConfig.getName(), uiSoundsConfig.getIcon(), btn -> this.minecraft.setScreen(uiSoundsConfig.getYACL().generateScreen((Screen)this)));
        this.addRenderableWidget((GuiEventListener)uiSoundsButton);
        int discordAndKoFiButtonsWidth = 193;
        int doneButtonWidth = this.width - discordAndKoFiButtonsWidth;
        GreyButton buttonWidget = new GreyButton(180, this.height - 30, doneButtonWidth, 20, CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this.parent), Supplier::get);
        GreyButton koFiButton = new GreyButton(10, this.height - 30, 80, 20, (Component)Component.literal((String)"Donate").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD), btn -> Util.getPlatform().openUri("https://ko-fi.com/imb11"), Supplier::get);
        GreyButton discordButton = new GreyButton(95, this.height - 30, 80, 20, (Component)Component.literal((String)"Discord").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD), btn -> Util.getPlatform().openUri("https://discord.imb11.dev/"), Supplier::get);
        this.addRenderableWidget((GuiEventListener)buttonWidget);
        this.addRenderableWidget((GuiEventListener)koFiButton);
        this.addRenderableWidget((GuiEventListener)discordButton);
    }
}

