/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.sound.events;

import dev.imb11.sounds.config.EventSoundsConfig;
import dev.imb11.sounds.config.SoundsConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class PotionEventHelper {
    private final AtomicReference<Map<ResourceLocation, MobEffectInstance>> previousEffects = new AtomicReference<Object>(null);

    public void listenForEffectChanges(ClientLevel clientWorld) {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return;
        }
        HashMap currentEffects = new HashMap();
        client.player.getActiveEffects().forEach(effectInstance -> {
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            currentEffects.put(BuiltInRegistries.MOB_EFFECT.getKey((Object)effect), effectInstance);
        });
        if (this.previousEffects.get() != null) {
            HashMap<ResourceLocation, MobEffectInstance> removedEffects = new HashMap<ResourceLocation, MobEffectInstance>(this.previousEffects.get());
            removedEffects.keySet().removeAll(currentEffects.keySet());
            for (ResourceLocation effectId : removedEffects.keySet()) {
                MobEffect statusEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(effectId);
                if (statusEffect == null || SoundsConfig.get(EventSoundsConfig.class).ignoreSilencedStatusEffects && !((MobEffectInstance)removedEffects.get(effectId)).showIcon()) continue;
                if (statusEffect.isBeneficial()) {
                    SoundsConfig.get(EventSoundsConfig.class).positiveStatusEffectLoseSoundEffect.playSound();
                    continue;
                }
                SoundsConfig.get(EventSoundsConfig.class).negativeStatusEffectLoseSoundEffect.playSound();
            }
            HashMap addedEffects = new HashMap(currentEffects);
            addedEffects.keySet().removeAll(this.previousEffects.get().keySet());
            for (ResourceLocation effectId : addedEffects.keySet()) {
                MobEffect statusEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(effectId);
                if (statusEffect == null || SoundsConfig.get(EventSoundsConfig.class).ignoreSilencedStatusEffects && !((MobEffectInstance)addedEffects.get(effectId)).showIcon()) continue;
                if (statusEffect.isBeneficial()) {
                    SoundsConfig.get(EventSoundsConfig.class).positiveStatusEffectGainSoundEffect.playSound();
                    continue;
                }
                SoundsConfig.get(EventSoundsConfig.class).negativeStatusEffectGainSoundEffect.playSound();
            }
        }
        this.previousEffects.set(currentEffects);
    }
}

