package dev.imb11.sounds.api.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.mru.LoaderUtils;
import dev.imb11.mru.RegistryUtils;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.util.MixinStatics;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_370;
import net.minecraft.class_6880;

public class ConfiguredSound {
    public static final Codec<ConfiguredSound> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    Codec.STRING.fieldOf("id").forGetter(ConfiguredSound::getId),
                    class_2960.field_25139.fieldOf("soundEvent").forGetter(sound -> sound.soundEvent),
                    Codec.BOOL.fieldOf("shouldPlay").forGetter(ConfiguredSound::shouldPlay),
                    Codec.FLOAT.fieldOf("pitch").forGetter(ConfiguredSound::getPitch),
                    Codec.FLOAT.fieldOf("volume").forGetter(ConfiguredSound::getVolume)
            ).apply(instance, ConfiguredSound::new));
    public final String id;
    public boolean enabled;
    public class_2960 soundEvent;
    public float pitch = 1f;
    public float volume = 1f;
    private float _pendingPitch = 1f;
    private float _pendingVolume = 1f;
    private class_2960 _pendingSoundEvent;

    public ConfiguredSound(String id, class_2960 soundEvent, boolean enabled, float pitch, float volume) {
        this.enabled = enabled;
        this.soundEvent = soundEvent;
        this.pitch = pitch;
        this.volume = volume;

        _pendingPitch = pitch;
        _pendingVolume = volume;
        _pendingSoundEvent = this.soundEvent;

        this.id = id;
//        this.client = Minecraft.getInstance();
    }

    public ConfiguredSound(String id, class_6880.class_6883<class_3414> soundEvent, boolean enabled, float pitch, float volume) {
        this(id, soundEvent.method_40237().method_29177(), enabled, pitch, volume);
    }

    public ConfiguredSound(String id, class_3414 soundEvent, boolean enabled, float pitch, float volume) {
        //? if <1.21.2 {
        this(id, soundEvent.method_14833(), enabled, pitch, volume);
        //?} else {
        /*this(id, soundEvent.location(), enabled, pitch, volume);
        *///?}
    }

    public ConfiguredSound(String id, class_6880<class_3414> soundEvent, boolean enabled, float pitch, float volume) {
        this(id, soundEvent.comp_349(), enabled, pitch, volume);
    }

    private <T extends ConfiguredSound> ArrayList<Option<?>> createDefaultOptions(T defaults) {
        var volumeOpt = Option.<Float>createBuilder()
                .name(class_2561.method_43471("sounds.config.volume.name"))
                .description(OptionDescription.createBuilder()
                                .text(class_2561.method_43471("sounds.config.volume.description")).build())
                .binding(defaults.volume, () -> this.volume, (val) -> this.volume = val)
                .listener((opt, val) -> {
                    this._pendingVolume = val;
                })
                .controller(opt -> FloatSliderControllerBuilder.create(opt).step(0.1f).range(0f, 2f))
                .build();

        var pitchOpt = Option.<Float>createBuilder()
                .name(class_2561.method_43471("sounds.config.pitch.name"))
                .description(OptionDescription.createBuilder()
                        .text(class_2561.method_43471("sounds.config.pitch.description")).build())
                .binding(defaults.pitch, () -> this.pitch, (val) -> this.pitch = val)
                .listener((opt, val) -> {
                    this._pendingPitch = val;
                })
                .controller(opt -> FloatSliderControllerBuilder.create(opt).step(0.1f).range(0f, 2f))
                .build();

        var soundEventOpt = Option.<String>createBuilder()
                .name(class_2561.method_43471("sounds.config.event.name"))
                .description(OptionDescription.createBuilder()
                        .text(class_2561.method_43471("sounds.config.event.description")).build())
                .binding(defaults.soundEvent.toString(), () -> this.soundEvent.toString(), (val) ->
                        this.soundEvent = class_2960.method_60654(val))
                .listener((opt, val) -> this._pendingSoundEvent = class_2960.method_60654(val))
                .controller(opt -> DropdownStringControllerBuilder.create(opt)
                        .allowAnyValue(false)
                        .allowEmptyValue(false)
                        .values(MixinStatics.FOUND_SOUND_EVENTS.stream().map(class_2960::toString).toList()))
                .build();

        return new ArrayList<>(List.of(volumeOpt, pitchOpt, soundEventOpt));
    }

    public <T extends ConfiguredSound> ArrayList<Option<?>> addExtraOptions(T defaults) {
        return new ArrayList<>();
    }

    public ButtonOption getPreviewButton() {
        return ButtonOption.createBuilder()
                .name(class_2561.method_43469("sounds.config.preview.name", ""))
                .description(OptionDescription.of(class_2561.method_43471("sounds.config.preview.option.description")))
                .action((a, b) -> playPreviewSound())
                .build();
    }

    public OptionGroup getOptionGroup(ConfiguredSound defaults) {
        ArrayList<Option<?>> defaultOptions = createDefaultOptions(defaults);
        ArrayList<Option<?>> extraOptions = addExtraOptions(defaults);
        ArrayList<Option<?>> allOptions = new ArrayList<>(defaultOptions);
        allOptions.addAll(extraOptions);

        var shouldPlay = Option.<Boolean>createBuilder()
                .name(class_2561.method_43471("sounds.config.shouldPlay.option"))
                .description(OptionDescription.createBuilder()
                        .text(class_2561.method_43471("sounds.config.shouldPlay.option.description")).build())
                .binding(defaults.enabled, () -> this.enabled, (val) -> this.enabled = val)
                .listener((opt, val) -> {
                    // Disable/Enable all options when toggled.
                    allOptions.forEach(option -> option.setAvailable(val));
                })
                .controller(opt -> BooleanControllerBuilder.create(opt).coloured(true).yesNoFormatter())
                .build();

        return OptionGroup
                .createBuilder()
                .name(class_2561.method_43471("sounds.config." + id + ".option").method_27692(class_124.field_1073))
                .description(OptionDescription.createBuilder()
                        .text(class_2561.method_43471("sounds.config." + id + ".option.description")).build())
                .option(getPreviewButton())
                .option(shouldPlay)
                .options(allOptions)
                .collapsed(true)
                .build();
    }

    public final class_3414 fetchSoundEvent(class_2960 location) {
        return RegistryUtils.getSoundEventRegistry(class_310.method_1551().field_1687).apply(location);
    }

    protected static long lastShownToast = -1L;

    public void playSound() {
        if (this.enabled) {
            try {
                this.playSound(this.soundEvent, this.pitch, this.volume);
            } catch (Exception ignored) {
                // Prevent toast spam:
                ignored.printStackTrace();
                if (System.currentTimeMillis() > lastShownToast + 5000) {
                    lastShownToast = System.currentTimeMillis();
                    class_310 client = class_310.method_1551();

                    //? if <1.21.2 {
                    var toastManager = client.method_1566();
                    //?} else {
                    /*var toastManager = client.getToastManager();
                    *///?}

                    toastManager.method_1999(class_370.method_29047(client,
                            class_370.class_9037.field_47586,
                            class_2561.method_43471("sounds.config.play.error.title"),
                            class_2561.method_43469("sounds.config.play.error.description", this.getId())));
                }
            }
        }
    }

    private void playPreviewSound() {
        try {
            this.playSound(this._pendingSoundEvent, _pendingPitch, _pendingVolume);
        } catch (Exception ignored) {
            if (System.currentTimeMillis() > lastShownToast + 5000) {
                lastShownToast = System.currentTimeMillis();
                class_310 client = class_310.method_1551();

                //? if <1.21.2 {
                var toastManager = client.method_1566();
                //?} else {
                /*var toastManager = client.getToastManager();
                *///?}

                toastManager.method_1999(class_370.method_29047(client,
                        class_370.class_9037.field_47586,
                        class_2561.method_43471("sounds.config.preview.error.title"),
                        class_2561.method_43471("sounds.config.preview.error.description")));
            }
        }
    }

    private void playSound(class_2960 soundEvent, float pitch, float volume) {
        var pos = class_243.field_1353;
        var attenuation = class_1113.class_1114.field_5476;
        if (LoaderUtils.isModInstalled("sound_physics_perfected") && class_310.method_1551().field_1724 != null) {
            attenuation = class_1113.class_1114.field_5478;  // Disable Attenuation when using SPP
        }
        this.playSound(new class_1109(soundEvent, class_3419.field_15250, volume, pitch, SoundsClient.RANDOM, false, 0, attenuation, pos.field_1352, pos.field_1351, pos.field_1350, true));
    }

    public @Nullable class_1109 getSoundInstance() {
        if (this.enabled) {
            try {
                final class_3414 event = RegistryUtils.getSoundEventRegistry(class_310.method_1551().field_1687).apply(this.soundEvent);
                return class_1109.method_4757(event, pitch, volume);
            } catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public void playSound(class_1113 soundInstance) {
        if (this.enabled) {
            class_310.method_1551().method_1483().method_4873(soundInstance);
        }
    }

    public void stopSound(class_1113 soundInstance) {
        if (this.enabled) {
            class_310.method_1551().method_1483().method_4870(soundInstance);
        }
    }

    public boolean shouldPlay() {
        return enabled;
    }

    public class_2960 getSoundEvent() {
        return this.soundEvent;
    }

    public float getPitch() {
        return pitch;
    }

    public float getVolume() {
        return volume;
    }

    public String getId() {
        return id;
    }
}
