/*? if >=1.21 && fabric {*/
package dev.imb11.sounds.api.datagen;

import dev.imb11.sounds.api.SoundDefinition;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricCodecDataProvider;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class SoundDefinitionProvider<T> extends FabricCodecDataProvider<SoundDefinition<T>> {
    private final class_2378<T> registry;

    protected SoundDefinitionProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture, String outputFolder, class_2378<T> registry) {
        super(dataOutput, registriesFuture, class_7784.class_7490.field_39368, "sounds/" + outputFolder, SoundDefinition.getCodec(registry.method_30517()));
        this.registry = registry;
    }

    public SoundDefinition.Builder<T> create(class_2960 event) {
        return new SoundDefinition.Builder<T>(event, this.registry);
    }

    public SoundDefinition.Builder<T> create(class_3414 event) {
        return this.create(event.method_14833());
    }

    public SoundDefinition.Builder<T> create(class_6880<class_3414> event) {
        return this.create(event.method_40230().get().method_29177());
    }

    @Override
    protected void configure(BiConsumer<class_2960, SoundDefinition<T>> provider, class_7225.class_7874 lookup) {
        accept((s, tSoundDefinition) -> provider.accept(class_2960.method_60654(s), tSoundDefinition.build()));
    }

    public abstract void accept(BiConsumer<String, SoundDefinition.Builder<T>> provider);

    @Override
    public @NotNull String method_10321() {
        return "SoundDefinition[" + this.registry.method_30517().method_29177() + "]Provider";
    }
}
/*?}*/