/*? if >=1.21 && fabric {*/
package dev.imb11.sounds.api.datagen;

import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.config.TagPair;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricCodecDataProvider;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class TagPairProvider extends FabricCodecDataProvider<TagPair> {

    protected TagPairProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(dataOutput, registriesFuture, class_7784.class_7490.field_39368, "sounds/blocks", TagPair.CODEC);
    }

    @Override
    protected void configure(BiConsumer<class_2960, TagPair> provider, class_7225.class_7874 lookup) {
        accept((s, tTagPair) -> provider.accept(class_2960.method_60654(s), tTagPair.build()));
    }

    public abstract void accept(BiConsumer<String, TagPair.Builder> provider);

    @Override
    public String method_10321() {
        return "TagPairProvider";
    }
}
/*?}*/