package dev.imb11.sounds.config;

import dev.imb11.mru.LoaderUtils;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;

import static dev.imb11.sounds.config.SoundsConfig.HELPER;

public class ChatSoundsConfig extends ConfigGroup<ChatSoundsConfig> implements YetAnotherConfigLib.ConfigBackedBuilder<ChatSoundsConfig> {
    // == MESSAGING SOUNDS == //
    @SerialEntry
    public final ConfiguredSound typingSoundEffect = new ConfiguredSound("typing", class_3417.field_15204, true, 1.6f, 0.4f);
    @SerialEntry
    public final ConfiguredSound messageSoundEffect = new ConfiguredSound("message", class_3417.field_15204, true, 2.0f, 0.8f);
    @SerialEntry
    public final ConfiguredSound mentionSoundEffect = new ConfiguredSound("mention", class_3417.field_14725, true, 1.8f, 0.9f);
    @SerialEntry
    public ArrayList<String> mentionKeywords = new ArrayList<>(List.of(
            "@" + class_310.method_1551().method_1548().method_1676()
    ));
    @SerialEntry
    public boolean ignoreSystemChats = false;
    // == COOLDOWN SETTINGS == //
    @SerialEntry
    public boolean enableChatSoundCooldown = false;
    @SerialEntry
    public float chatSoundCooldown = 0.5f;

    public ChatSoundsConfig() {
        super(ChatSoundsConfig.class);
    }

    @Override
    public YetAnotherConfigLib getYACL() {
        return YetAnotherConfigLib.create(getHandler(), this);
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655("sounds", "textures/gui/chat_sounds.png");
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471("sounds.config.chat");
    }

    @Override
    public String getID() {
        return "chat";
    }

    @Override
    public YetAnotherConfigLib.Builder build(ChatSoundsConfig defaults, ChatSoundsConfig config, YetAnotherConfigLib.Builder builder) {
        Option<Float> chatSoundCooldownOption = HELPER.getField("chatSoundCooldown", defaults.chatSoundCooldown, () -> config.chatSoundCooldown, v -> config.chatSoundCooldown = v);

        ListOption<String> mentionKeywordsOption = ListOption.<String>createBuilder()
                .name(class_2561.method_43471("sounds.config.mentionKeywords.option"))
                .description(OptionDescription.of(class_2561.method_43471("sounds.config.mentionKeywords.option.description")))
                .binding(defaults.mentionKeywords, () -> config.mentionKeywords, (value) -> config.mentionKeywords = new ArrayList<>(value))
                .controller(StringControllerBuilder::create)
                .initial("@" + class_310.method_1551().method_1548().method_1676())
                .insertEntriesAtEnd(true)
                .build();

        builder.title(class_2561.method_30163("Chat Sounds"));
        builder.category(ConfigCategory.createBuilder()
                .name(class_2561.method_43471("sounds.config.chat.messaging"))
                .option(HELPER.get("ignoreSystemChats", defaults.ignoreSystemChats, () -> config.ignoreSystemChats, v -> config.ignoreSystemChats = v))
                .group(config.typingSoundEffect.getOptionGroup(defaults.typingSoundEffect))
                .group(config.messageSoundEffect.getOptionGroup(defaults.messageSoundEffect))
                .group(config.mentionSoundEffect.getOptionGroup(defaults.mentionSoundEffect))
                .option(mentionKeywordsOption)
                .build());

        builder.category(ConfigCategory.createBuilder()
                .name(class_2561.method_43471("sounds.config.chat.cooldown"))
                .option(Option.<Boolean>createBuilder()
                        .name(class_2561.method_43471("sounds.config.option.enableChatSoundCooldown"))
                        .description(OptionDescription.of(class_2561.method_43471("sounds.config.option.description.enableChatSoundCooldown")))
                        .binding(defaults.enableChatSoundCooldown, () -> config.enableChatSoundCooldown, v -> config.enableChatSoundCooldown = v)
                        .controller((opt) -> BooleanControllerBuilder.create(opt).coloured(true).yesNoFormatter())
                        .available(!(LoaderUtils.isModInstalled("chatpatches")))
                        .build())
                .option(chatSoundCooldownOption)
                .build());

        return builder;
    }
}
