package dev.imb11.sounds.config;

import dev.imb11.mru.yacl.EntryType;
import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.api.config.DynamicConfiguredSound;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.imb11.sounds.sound.CustomSounds;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.sound.context.RepeaterSoundContext;
import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

import static dev.imb11.sounds.config.SoundsConfig.HELPER;

public class WorldSoundsConfig extends ConfigGroup<WorldSoundsConfig> implements YetAnotherConfigLib.ConfigBackedBuilder<WorldSoundsConfig> {
    /// == MECHANICS == ///
    @SerialEntry
    public DynamicConfiguredSound<Integer, RepeaterSoundContext> repeaterUseSoundEffect = new DynamicConfiguredSound<>("repeaterUse", class_3417.field_14791, true, 0.95F, 0.3F, true);
    @SerialEntry
    public ConfiguredSound jukeboxUseSoundEffect = new ConfiguredSound("jukeboxUse", class_3417.field_15047, true, 0.8F, 0.75F);
    @SerialEntry
    public ConfiguredSound daylightDetectorUseSoundEffect = new ConfiguredSound("daylightDetectorUse", class_3417.field_15204, true, 0.8F, 0.45F);
    @SerialEntry
    public ConfiguredSound furnaceMinecartFuelSoundEffect = new ConfiguredSound("furnaceMinecartFuel", class_3417.field_15192, true, 1.9F, 0.2F);

    /// == ACTIONS == ///
    @SerialEntry
    public ConfiguredSound swordSwooshSoundEffect = new ConfiguredSound("swordSwoosh", class_2960.method_60655("sounds", "item.sword.swoosh"), true, 1.3F, 0.3F);
    @SerialEntry
    public ConfiguredSound frostWalkerSoundEffect = new ConfiguredSound("frostWalker", class_3417.field_27849, true, 2.0F, 0.5F);
    @SerialEntry
    public ConfiguredSound leadSnappingSoundEffect = new ConfiguredSound("leadSnapping", class_3417.field_15184, true, 1.0F, 0.5F);
    @SerialEntry
    public ConfiguredSound bowPullSoundEffect = new ConfiguredSound("bowPull", class_3417.field_14860, true, 1.0F, 0.25F);
    @SerialEntry
    public DynamicConfiguredSound<class_1799, ItemStackSoundContext> plantPotFillSoundEffect = new DynamicConfiguredSound<>("plantPotFill", class_3417.field_14653, true, 1.1F, 0.4F, true);
    @SerialEntry
    public ConfiguredSound cakeEatSoundEffect = new ConfiguredSound("cakeEat", class_3417.field_20614, true, 1.2F, 0.7F);
    @SerialEntry
    public boolean enableEnderpearlVariety = true;
    @SerialEntry
    public boolean disableBlocksEntirely = false;
    @SerialEntry
    public List<String> ignoredBlocks = new ArrayList<>();

    public WorldSoundsConfig() {
        super(WorldSoundsConfig.class);
    }

    @Override
    public YetAnotherConfigLib getYACL() {
        return YetAnotherConfigLib.create(getHandler(), this);
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655("sounds", "textures/gui/world_sounds.png");
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471("sounds.config.world");
    }

    @Override
    public String getID() {
        return "world";
    }

    @Override
    public YetAnotherConfigLib.Builder build(WorldSoundsConfig defaults, WorldSoundsConfig config, YetAnotherConfigLib.Builder builder) {
        builder.title(class_2561.method_30163("World Sounds"));
        builder.category(ConfigCategory.createBuilder()
                .name(class_2561.method_43471("sounds.config.world.mechanics"))
                .group(config.repeaterUseSoundEffect.getOptionGroup(defaults.repeaterUseSoundEffect))
                .group(config.jukeboxUseSoundEffect.getOptionGroup(defaults.jukeboxUseSoundEffect))
                .group(config.daylightDetectorUseSoundEffect.getOptionGroup(defaults.daylightDetectorUseSoundEffect))
                .group(config.furnaceMinecartFuelSoundEffect.getOptionGroup(defaults.furnaceMinecartFuelSoundEffect))
                .build());
        builder.category(ConfigCategory.createBuilder()
                .name(class_2561.method_43471("sounds.config.world.blocks"))
                .option(HELPER.get("disableBlocksEntirely", defaults.disableBlocksEntirely, () -> config.disableBlocksEntirely, v1 -> config.disableBlocksEntirely = v1))
                .option(LabelOption.create(class_2561.method_43471("sounds.config.world.blocks.description")))
                .option(ButtonOption.createBuilder()
                        .name(class_2561.method_30163("Open Wiki"))
                        .description(OptionDescription.EMPTY)
                        .action((screen, option) -> class_156.method_668().method_670("https://docs.imb11.dev/sounds/data/custom-block-sounds"))
                        .build())
                .option(LabelOption.create(class_2561.method_43473()))
                .option(ListOption.<String>createBuilder()
                        .name(HELPER.getText(EntryType.OPTION_NAME, "ignoredBlocks"))
                        .description(OptionDescription.of(HELPER.getText(EntryType.OPTION_DESCRIPTION, "ignoredBlocks")))
                        .binding(defaults.ignoredBlocks, () -> config.ignoredBlocks, (val) -> config.ignoredBlocks = val)
                        .controller(opt -> DropdownStringControllerBuilder.create(opt)
                                .allowEmptyValue(false)
                                .values(class_7923.field_41175.method_42021().stream()
                                        .map(class_5321::method_29177)
                                        .map(class_2960::toString).toList()))
                        .initial("minecraft:grass_block")
                        .build()
                )
                .build());
        builder.category(ConfigCategory.createBuilder()
                .name(class_2561.method_43471("sounds.config.world.actions"))
                .option(HELPER.get("enableEnderpearlVariety", defaults.enableEnderpearlVariety, () -> config.enableEnderpearlVariety, v -> config.enableEnderpearlVariety = v))
                .group(config.swordSwooshSoundEffect.getOptionGroup(defaults.swordSwooshSoundEffect))
                .group(config.frostWalkerSoundEffect.getOptionGroup(defaults.frostWalkerSoundEffect))
                .group(config.leadSnappingSoundEffect.getOptionGroup(defaults.leadSnappingSoundEffect))
                .group(config.bowPullSoundEffect.getOptionGroup(defaults.bowPullSoundEffect))
                .group(config.plantPotFillSoundEffect.getOptionGroup(defaults.plantPotFillSoundEffect))
                .group(config.cakeEatSoundEffect.getOptionGroup(defaults.cakeEatSoundEffect))
                .build());

        return builder;
    }
}
