package dev.imb11.sounds.dynamic;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.JsonOps;
import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.config.ChatSoundsConfig;
import dev.imb11.sounds.config.SoundsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SoundsReloadListener extends class_4080<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundsReloadListener.class);
    private static final Gson GSON = new Gson();

    public void reload(class_3300 manager) {
        handleDynamicSounds(manager);

        // Load tag pairs
        TagPairHelper.LOADED_TAG_PAIRS.clear();

        for (class_2960 id : manager.method_14488("sounds/blocks", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                var resource = manager.method_14486(id).orElseThrow();
                var inputStream = resource.method_14482();
                var reader = new JsonReader(new InputStreamReader(inputStream));

                TagPair.CODEC.decode(JsonOps.INSTANCE, GSON.fromJson(reader, JsonObject.class))
                        .result()
                        .ifPresent(tagPair -> TagPairHelper.LOADED_TAG_PAIRS.put(id, tagPair.getFirst()));

                inputStream.close();
            } catch (Exception e) {
                LOGGER.error("Error occurred while loading resource json: " + id.toString(), e);
            }
        }

        TagPairHelper.buildCache();
    }

    private static void handleDynamicSounds(class_3300 manager) {
        DynamicSoundHelper.clearDefinitions();
        DynamicSoundHelper.loadDirectories.forEach((directory, codec) -> {
            ArrayList<SoundDefinition<?>> resultList = (ArrayList<SoundDefinition<?>>) DynamicSoundHelper.loadedDefinitions.get(directory);

            for (class_2960 id : manager.method_14488("sounds/" + directory, path -> path.method_12832().endsWith(".json")).keySet()) {
                try {
                    var resource = manager.method_14486(id).orElseThrow();
                    var inputStream = resource.method_14482();
                    var reader = new JsonReader(new InputStreamReader(inputStream));

                    SoundDefinition<?> result = (SoundDefinition<?>) codec.parse(JsonOps.INSTANCE, GSON.fromJson(reader, JsonObject.class)).result().orElseThrow();

                    resultList.add(result);

                    inputStream.close();
                } catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource json: " + id.toString(), e);
                }
            }

            DynamicSoundHelper.loadedDefinitions.put(directory, resultList);
        });

        // List all items that do not have a dynamic sound event that isn't a BlockItem
        ArrayList<class_1792> items = new ArrayList<>();
        class_7923.field_41178.forEach(item -> {
            items.add(item);
        });

        ArrayList<class_1792> itemsWithLoadedDefinitions = new ArrayList<>();

        DynamicSoundHelper.loadedDefinitions.get("items").forEach(definition -> {
            SoundDefinition<class_1792> definitionCast = (SoundDefinition<class_1792>) definition;

            for (Either<class_5321<class_1792>, class_6862<class_1792>> registryKeyTagKeyEither : definitionCast.getKeys().getInternalList()) {
                if (registryKeyTagKeyEither.left().isPresent()) {
                    var key = registryKeyTagKeyEither.left().get();
                    var entry = class_7923.field_41178.method_10223(key.method_29177());

                    itemsWithLoadedDefinitions.add(entry);
                } else if (registryKeyTagKeyEither.right().isPresent()) {
                    var tagKey = registryKeyTagKeyEither.right().get();

                    var entries = class_7923.field_41178.method_40260(tagKey);

                    for (class_6880<class_1792> key : entries) {
                        var entry = class_7923.field_41178.method_29107(key.method_40230().get());
                        itemsWithLoadedDefinitions.add(entry);
                    }
                }
            }
        });
    }

    @Override
    protected Void method_18789(class_3300 manager, class_3695 profiler) {
        profiler.method_15396("SoundsReloadListener");
        this.reload(manager);
        profiler.method_15407();
        return null;
    }

    @Override
    protected void apply(Void prepared, class_3300 manager, class_3695 profiler) {
        // NO-OP
    }
}
