package dev.imb11.sounds.gui;

import com.mojang.blaze3d.systems.RenderSystem;

import static org.lwjgl.opengl.GL20.*;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class ImageButtonWidget extends class_339 {
    float durationHovered = 0f;
    private final class_2960 imageLocation;
    private final Consumer<ImageButtonWidget> onPress;
    private static final int ICON_SIZE = 32; // Fixed icon size
    private static final int ICON_TEXT_SPACING = 5;

    public ImageButtonWidget(int x, int y, int width, int height, class_2561 message, class_2960 imageLocation, Consumer<ImageButtonWidget> clickEvent) {
        super(x, y, width, height, message);
        this.imageLocation = imageLocation;
        this.onPress = clickEvent;
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;

        if (this.field_22762 || this.method_25370()) {
            durationHovered = Math.min(durationHovered + delta / 2f, 1f);
        } else {
            durationHovered = Math.max(durationHovered - delta / 4f, 0f);
        }

        float alphaScale = class_3532.method_37166(0.9f, 0.5f, durationHovered);

        // Grey overlay for hover effect (render first, behind icon and text)
        int a = (int) (255 * alphaScale);
        int greyColor = (a << 24);

        context.method_25294(method_46426(), method_46427(), method_46426() + field_22758, method_46427() + field_22759, greyColor);

        // Prepare for icon and text rendering
        class_310 client = class_310.method_1551();
        int fontHeight = client.field_1772.field_2000;
        int textWidth = client.field_1772.method_27525(method_25369());

        // Determine layout: vertical or horizontal
        int totalHorizontalWidth = ICON_SIZE + ICON_TEXT_SPACING + textWidth;
        boolean preferHorizontal = totalHorizontalWidth <= this.field_22758 && this.field_22758 >= 2f * this.field_22759;
        boolean verticalLayout = !preferHorizontal;

        int iconX, iconY; // Declare icon position variables here

        if (verticalLayout) {
            // Vertical Layout: Icon above text
            int totalHeight = ICON_SIZE + ICON_TEXT_SPACING + fontHeight;

            iconY = method_46427() + (this.field_22759 - totalHeight) / 2;

            List<class_5481> wrappedText = client.field_1772.method_1728(method_25369(), this.field_22758 - 20);
            int wrappedTextHeight = wrappedText.size() * fontHeight;
            int textY = iconY + ICON_SIZE + ICON_TEXT_SPACING;

            if (wrappedText.size() > 1) {
                int textStartY = textY + (fontHeight - wrappedTextHeight) / 2;
                int currentTextY = textY;

                int combinedTotalHeight = ICON_SIZE + ICON_TEXT_SPACING + wrappedTextHeight;
                int overallStartY = method_46427() + (this.field_22759 - combinedTotalHeight) / 2;
                iconY = overallStartY;
                iconX = method_46426() + (this.field_22758 - ICON_SIZE) / 2;
                textY = overallStartY + ICON_SIZE + ICON_TEXT_SPACING;
                currentTextY = textY;
                // Re-render icon with recalculated position if needed, though in this case, position hasn't changed significantly in terms of icon rendering itself.
                renderIcon(context, iconX, iconY);


                for (class_5481 line : wrappedText) {
                    context.method_35719(client.field_1772, line, method_46426() + this.field_22758 / 2, currentTextY, 0xFFFFFF);
                    currentTextY += fontHeight;
                }
            } else {
                int combinedTotalHeight = ICON_SIZE + ICON_TEXT_SPACING + fontHeight;
                int overallStartY = method_46427() + (this.field_22759 - combinedTotalHeight) / 2;
                iconY = overallStartY;
                iconX = method_46426() + (this.field_22758 - ICON_SIZE) / 2;
                textY = overallStartY + ICON_SIZE + ICON_TEXT_SPACING;
                renderIcon(context, iconX, iconY);
                context.method_27534(client.field_1772, method_25369(), method_46426() + this.field_22758 / 2, textY, 0xFFFFFF);
            }
        } else {
            // Horizontal Layout: Icon left of text
            int totalWidth = ICON_SIZE + ICON_TEXT_SPACING + textWidth;
            int startX = method_46426() + (this.field_22758 - totalWidth) / 2;

            iconX = startX;
            iconY = method_46427() + (this.field_22759 - ICON_SIZE) / 2;

            renderIcon(context, iconX, iconY);

            int textX = iconX + ICON_SIZE + ICON_TEXT_SPACING;
            int textY = method_46427() + (this.field_22759 - fontHeight) / 2;

            List<class_5481> wrappedText = client.field_1772.method_1728(method_25369(), this.field_22758 - ICON_SIZE - ICON_TEXT_SPACING - 10);
            if (wrappedText.size() > 1) {
                int wrappedTextHeight = wrappedText.size() * fontHeight;
                int textStartY = method_46427() + (this.field_22759 - wrappedTextHeight) / 2;
                int currentTextY = textStartY;
                for (class_5481 line : wrappedText) {
                    context.method_35720(client.field_1772, line, textX, currentTextY, 0xFFFFFF);
                    currentTextY += fontHeight;
                }
            } else {
                context.method_27535(client.field_1772, method_25369(), textX, textY, 0xFFFFFF);
            }
        }

        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);

        context.method_49601(method_46426(), method_46427(), field_22758, field_22759, 0x0FFFFFFF);
    }

    private static void renderTexture(class_332 drawContext, class_2960 texture, int x, int y, int textureWidth, int textureHeight) {
        drawContext.method_25290(texture, x, y, 0, 0, textureWidth, textureHeight, textureWidth, textureHeight);
    }


    private void renderIcon(class_332 context, int x, int y) {
        int minFilterScalingTypePrev = glGetTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER);
        int magFilterScalingTypePrev = glGetTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER);
        try {
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
            context.method_51448().method_22903();

            context.method_51448().method_22905(32f / 512f, 32f / 512f, 1.0f);
            context.method_25290(this.imageLocation, (int) (x / (32f / 512f)), (int) (y / (32f / 512f)), 0, 0, 512, 512, 512, 512);
            context.method_51448().method_22909();
        } catch (Exception ignored) {} finally {
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, minFilterScalingTypePrev);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, magFilterScalingTypePrev);
        }
    }


    @Override
    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33790, this.method_25369());
    }
}