package dev.imb11.sounds.gui;

import dev.imb11.mru.RenderUtils;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.config.*;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class SoundsConfigScreen extends class_437 {
    private final class_437 parent;

    public SoundsConfigScreen(@Nullable class_437 parent) {
        super(class_2561.method_43471("sounds.config.title"));
        this.parent = parent;
    }

    @Override
    public void method_25419() {
        assert this.field_22787 != null;
        this.field_22787.method_1507(this.parent);
    }

    public float timeSinceLastSupporter = -1;
    public int supporterIndex = -1;

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);

        assert this.field_22787 != null;
        context.method_27534(this.field_22787.field_1772, class_2561.method_43471("sounds.config.title"), this.field_22789 / 2, 10, 0xFFFFFF);

        /*
        if(timeSinceLastSupporter == -1) {
            timeSinceLastSupporter = Util.getMillis();
            supporterIndex = 0;
        }

        if(timeSinceLastSupporter + 2000 < Util.getMillis()) {
            supporterIndex++;
            if(supporterIndex >= SoundsClient.SUPPORTERS.length) {
                supporterIndex = 0;
            }
            timeSinceLastSupporter = Util.getMillis();
        }

        String supporter = SoundsClient.SUPPORTERS[supporterIndex];



        float timePassed = (Util.getMillis() - timeSinceLastSupporter) / 2000f;
        float fadeBetween = (Mth.sin(timePassed * (float)Math.PI) + 1) / 2;
        if(fadeBetween < 0.01) {
            fadeBetween = 0;
        }
        int alpha = (int) (fadeBetween * 255.0f);
        int color = (alpha << 24) | (0xFFFFFF);
        Component text = Component.literal(supporter).withStyle(ChatFormatting.GOLD).append(Component.literal(" supports me on Ko-Fi!").withStyle(ChatFormatting.WHITE));

        int textX = (int) 10;

        int spaceBetween = (this.width / 2 - 40);
        int textTotalHeight = font.wordWrapHeight(text, spaceBetween - 20);
        int targetY = 10 + font.lineHeight / 2;
        int textY = targetY - (textTotalHeight / 2);
       
         */
        // TODO: Reimpl this.
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int fontHeight = field_22793.field_2000;
        int gridX = 10;
        int gridY = 10 + fontHeight + 10;
        int gridWidth = field_22789 - 15;
        int gridHeight = field_22790 - 20 - fontHeight - 10 - 20;

        int numColumns = 4;
        int numRows = 3;

        int cellWidth = gridWidth / numColumns;
        int cellHeight = gridHeight / numRows;

        WorldSoundsConfig worldSoundsConfig = SoundsConfig.getRaw(WorldSoundsConfig.class);
        ImageButtonWidget worldSoundsButton = new ImageButtonWidget(
                gridX + 0 * cellWidth, gridY + 0 * cellHeight, 2 * cellWidth - 6, 2 * cellHeight - 6, // -6 for padding of 3 on each side
                worldSoundsConfig.getName(), worldSoundsConfig.getIcon(), btn -> {
            this.field_22787.method_1507(worldSoundsConfig.getYACL().generateScreen(this));
        });
        method_37063(worldSoundsButton);

        ChatSoundsConfig chatSoundsConfig = SoundsConfig.getRaw(ChatSoundsConfig.class);
        ImageButtonWidget chatSoundsButton = new ImageButtonWidget(
                gridX + 2 * cellWidth, gridY + 0 * cellHeight, 2 * cellWidth - 6, cellHeight - 6,
                chatSoundsConfig.getName(), chatSoundsConfig.getIcon(), btn -> {
            this.field_22787.method_1507(chatSoundsConfig.getYACL().generateScreen(this));
        });
        method_37063(chatSoundsButton);

        EventSoundsConfig eventSoundsConfig = SoundsConfig.getRaw(EventSoundsConfig.class);
        ImageButtonWidget eventSoundsButton = new ImageButtonWidget(
                gridX + 2 * cellWidth, gridY + 1 * cellHeight, cellWidth - 6, cellHeight - 6,
                eventSoundsConfig.getName(), eventSoundsConfig.getIcon(), btn -> {
            this.field_22787.method_1507(eventSoundsConfig.getYACL().generateScreen(this));
        });
        method_37063(eventSoundsButton);

        ModConfig modConfig = SoundsConfig.getRaw(ModConfig.class);
        ImageButtonWidget modConfigButton = new ImageButtonWidget(
                gridX + 3 * cellWidth, gridY + 1 * cellHeight, cellWidth - 6, 2 * cellHeight - 6,
                modConfig.getName(), modConfig.getIcon(), btn -> {
            this.field_22787.method_1507(modConfig.getYACL().generateScreen(this));
        });
        method_37063(modConfigButton);

        UISoundsConfig uiSoundsConfig = SoundsConfig.getRaw(UISoundsConfig.class);
        ImageButtonWidget uiSoundsButton = new ImageButtonWidget(
                gridX + 0 * cellWidth, gridY + 2 * cellHeight, 3 * cellWidth - 6, cellHeight - 6,
                uiSoundsConfig.getName(), uiSoundsConfig.getIcon(), btn -> {
            this.field_22787.method_1507(uiSoundsConfig.getYACL().generateScreen(this));
        });
        method_37063(uiSoundsButton);

        int discordAndKoFiButtonsWidth = 80 + 80 + 33; // button widths + left margin of Ko-Fi button + right margin of Discord button
        int doneButtonWidth = this.field_22789 - discordAndKoFiButtonsWidth;
        class_4185 buttonWidget = new GreyButton(180, this.field_22790 - 30, doneButtonWidth, 20, class_5244.field_24334, (btn) -> this.field_22787.method_1507(this.parent), Supplier::get);
        class_4185 koFiButton = new GreyButton(10, this.field_22790 - 30, 80, 20, class_2561.method_43470("Donate").method_27692(class_124.field_1065).method_27692(class_124.field_1067), (btn) -> class_156.method_668().method_670("https://ko-fi.com/imb11"), Supplier::get);
        class_4185 discordButton = new GreyButton(95, this.field_22790 - 30, 80, 20, class_2561.method_43470("Discord").method_27692(class_124.field_1075).method_27692(class_124.field_1067), (btn) -> class_156.method_668().method_670("https://discord.imb11.dev/"), Supplier::get);
        this.method_37063(buttonWidget);
        this.method_37063(koFiButton);
        this.method_37063(discordButton);
    }
}